//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  Instantiates a live view and passes it to the PlaygroundSupport framework.
//

import UIKit
import BookCore
import PlaygroundSupport

// Instantiate a new instance of the live view from BookCore and pass it to PlaygroundSupport.
//PlaygroundPage.current.liveView = instantiateLiveView()

//Map定義
let rawMap: [[String]] = [
    ["A",   ".",   ".", ".",   ".", ".",   ".", "A", ".", "."],
    [".",   ".",   ".", ".",   ".", ".",   ".", ".", ".", "."],
    [".",   ".", "WI2", ".",   "G", ".", "WO2", ".", ".", "."],
    [".",   "A",   ".", ".",   ".", ".",   "A", ".", "A", "."],
    [".",   ".", "WO1", ".",   ".", ".",   ".", ".", ".", "."],
    [".",   ".",   ".", ".",   ".", ".",   ".", ".", ".", "."],
    ["A",   ".",   "A", "A", "WI1", ".",   ".", ".", ".", "."],
    [".",   ".",   "A", "S",   ".", "A",   ".", ".", "A", "."],
    [".",   ".",   ".", "A",   "A", ".",   ".", "A", ".", "."],
    [".",   "A",   ".", ".",   ".", ".",   ".", ".", ".", "."]
]
let maxFuel = 10
// 文字列から TileType に変換
let map: [[TileType]] = rawMap.map { row in
    row.map { cell in
        switch cell {
        case "S": return .player
        case "G": return .goal
        case "A": return .asteroid
        case let str where str.starts(with: "WI"): return .warpIn(id: Int(str.dropFirst(2))!)
        case let str where str.starts(with: "WO"): return .warpOut(id: Int(str.dropFirst(2))!)
        default: return .empty
        }
    }
}

let myViewController: MoveViewController = MoveViewController(map: map, maxFuel: maxFuel)
PlaygroundPage.current.liveView = myViewController
