//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import Foundation
import Network
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3
func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    Thread.sleep(forTimeInterval: 0.5)
    send("clear")
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.5)
        send("drop "+x.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func sendMessage(_ message: String) {
    send("message "+message)
}

//#-end-hidden-code
/*: some text
 ##  📖①落としてみる
　宝石を落としてみよう！\
 [drop()](glossary://drop)で指定した場所に宝石を落とす事ができます。\
　落とす場所は、左から１番目、２番目と、順に数えて10番目まで指定できます。\
　コードを実行できたら、任意の場所に宝石を落としてみましょう！
 * Important:
クラスルーム機能を使うときは、［ユーザー設定］ボタンで必要な項目を設定してください。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
//ここからプログラムです。

drop(1) //一番左に落とす。
drop(10) //一番右に落とす。
drop(4) //左から４番目に落とす。

//#-end-editable-code
//#-hidden-code

sendMessage("1,1,①-😊実行しました。")
//assessmentStatusを設定すると、実行が止まるので、必要な処理は全て済ませる。
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}

//#-end-hidden-code
