//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
var cNumber = 1
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3

var droped = [[0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0]]

var counter = [0,0,0,0,0,0,0,0,0,0]
var topColor = [0,0,0,0,0,0,0,0,0,0]

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    send("clear")
    send("color 1")
    cNumber = 1
    for i in 0 ... 9 {
        counter[i] = 0
        for j in 0 ... 9 {
            droped[i][j] = 0
        }
    }
}
func randomColor() {
    cNumber =  Int.random(in: 1..<4)
    color(cNumber)
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.5)
        send("drop "+x.description)
        if(counter[x-1] < 10) {
           droped[9-counter[x-1]][x-1] = cNumber
           counter[x-1] = counter[x-1] + 1
           topColor[x-1] = cNumber
        }
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
        cNumber = t
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func top(_ x: Int) -> Int {
    if(x > 0 && x < 11) {
        return topColor[x-1]
    } else {
        return 0
    }
}

func count(_ x: Int) -> Int {
    if(x > 0 && x < 11) {
        return counter[x-1]
    } else {
        return 0
    }
}

func sendMessage(_ message: String) {
    send("message "+message)
}

func check() {
    var clear = true
    for i in 0 ... 9 {
        for j in 0 ... 9 {
            if(droped[i][j] != answer[i][j]) {
                clear = false
            }
        }
    }
    if (clear == true) {
        sendMessage("11,1,⑪-😄できました！")
        PlaygroundPage.current.assessmentStatus = .pass(message: "😃おみごと！クリアーです!🎉")
    } else {
        sendMessage("11,2,⑪-🥶できていません")
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["🤔ざんねん！宝石の「いち」と「いろ」をかくにんしてみましょう。"], solution: nil)
    }
}

var answer = [[🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟦],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟥],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟩],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🟩],
              [🔳,🔳,🔳,🟥,🔳,🔳,🔳,🔳,🔳,🟩],
              [🔳,🔳,🔳,🟦,🔳,🔳,🔳,🔳,🔳,🟥],
              [🔳,🟩,🔳,🟩,🟥,🔳,🔳,🔳,🔳,🟥]]

//#-end-hidden-code
/*: some text
 ##  📖⑪条件で処理を変える(2)
 

　　プログラムで「判断」させる「条件」には、「等しい」、「等しくない」、「より大きい」、「より小さい」などが指定できます。\
 　ここでは、様々な「条件」をプログラムで指定してみましょう。\
 count(1)をつかうと、1番目の場所に落ちている宝石の「数」が判ります。そこで、次のような「条件」で宝石を落とすことにしましょう。\
　●もし、落ちている宝石の「数」が１個のときには、宝石を２つ落とす。\
　●もし、落ちている宝石の「数」が２個のときには、宝石を１つ落とす。\
　●もし、落ちている宝石の「数」が３個以上のときには、宝石を落とさない。\
　●もし、落とす「位置」が５以下のときは、落とす宝石の「色」は🟦にする。\
　●もし、落とす「位置」が６以上のときは、落とす宝石の「色」は🟥にする。\
 　プログラムが始まる前に1番目から順に10番目まで、でたらめな「数」の🟩の宝石が落とされます。\
 　そのあとからがあなたのプログラムがスタートします。1番目から順にに10番目まで「条件」に応じて落としましょう。
 
 * Important:
　「if」は、「もしも」という意味です。\
　「else」は「そうではない」という意味です。
 ---
 */
//#-code-completion(everything, hide)
//#-code-completion(identifier, show, 🟥, 🟩, 🟦)
//#-hidden-code
clear()
color(2)
for i in 1...10 {
    for j in 1...Int.random(in: 1..<4) {
      drop(i)
    }
}
color(1)
//#-end-hidden-code
//#-editable-code
//このプログラムは、毎回違う数の🟩の宝石が落ちてからスタートします。
//ここからプログラムです。
for i in 1...10 { //1〜10まで
    if(i <= 5) { //もし5番目番目以下だったら、
        color(3) //青色
    } else { //そうでないときは
        color(1) //赤色
    }
    if(count(i) == 1) { //もしi番目の数が1つのとき
        drop(i) //i番目に落とす。
        drop(i) //i番目に落とす。
    } else if (count(i) == 2) { //もしi番目が2つのとき
        drop(i) //i番目に落とす。
    }
}

//#-end-editable-code
//#-hidden-code
sendMessage("11,1,⑪-😊実行しました。")
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}
//#-end-hidden-code
