//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
var cNumber = 1
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3

var droped = [[0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0],
              [0,0,0,0,0,0,0,0,0,0]]

var counter = [0,0,0,0,0,0,0,0,0,0]
var topColor = [0,0,0,0,0,0,0,0,0,0]

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    send("clear")
    send("color 1")
    cNumber = 1
    for i in 0 ... 9 {
        counter[i] = 0
        for j in 0 ... 9 {
            droped[i][j] = 0
        }
    }
}
func randomColor() {
    cNumber =  Int.random(in: 1..<4)
    color(cNumber)
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.3)
        send("drop "+x.description)
        if(counter[x-1] < 10) {
           droped[9-counter[x-1]][x-1] = cNumber
           counter[x-1] = counter[x-1] + 1
           topColor[x-1] = cNumber
        }
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
        cNumber = t
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func top(_ x: Int) -> Int {
    if(x > 0 && x < 11) {
        return topColor[x-1]
    } else {
        return 0
    }
}

func count(_ x: Int) -> Int {
    if(x > 0 && x < 11) {
        return counter[x-1]
    } else {
        return 0
    }
}

func sendMessage(_ message: String) {
    send("message "+message)
}

func check() {
    var clear = true
    for i in 0 ... 9 {
        for j in 0 ... 9 {
            if(droped[i][j] != answer[i][j]) {
                clear = false
            }
        }
    }
    if (clear == true) {
        sendMessage("13,1,⑬-😄できました！")
        PlaygroundPage.current.assessmentStatus = .pass(message: "😃おみごと！クリアーです!🎉")
    } else {
        sendMessage("13,2,⑬-🥶できていません")
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["🤔ざんねん！宝石の「いち」と「いろ」をかくにんしてみましょう。"], solution: nil)
    }
}

var answer = [[🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳],
              [🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳,🔳]]

//#-end-hidden-code
/*: some text
 ##  💎⑬チャレンジしよう！
　次の「条件」で、プログラムをつくってください。\
　(1)1番目〜10番目の場所で、\
　(2)落ちていない場所を🟦の宝石で全て埋める。
 
 * Important:
　1個落ちている場所には9個、9個落ちている場所には1個、10個落ちている場所には宝石を落とさない事がポイントです。
 ---
 */
//#-code-completion(everything, hide)
//#-code-completion(identifier, show, 🟥, 🟩, 🟦)
//#-hidden-code
clear()
color(🟥)
for i in 1...10 {
    let a = Int.random(in: 0...10)
    if ( a > 0) {
        for j in 1...a {
            drop(i)
        }
    }
}
//解答作成
for i in 0...9 {
    for j in 0...9 {
        answer[j][i] = droped[j][i]
        if(answer[j][i] == 0) {
            answer[j][i] = 🟦
        }
    }
}
color(🟥)
//#-end-hidden-code
//#-editable-code
//このプログラムはランダムな「色」の宝石が落ちた後にスタートします。
//ここからプログラムを入力します。

//#-end-editable-code
//#-hidden-code
check()
//#-end-hidden-code
