//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3
func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    send("clear")
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.5)
        send("drop "+x.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}


func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func sendMessage(_ message: String) {
    send("message "+message)
}

//#-end-hidden-code
/*: some text
 ##  📖②色を変える
　別の「色」の宝石を落としてみよう！\
 [color()](glossary://color)で落とす宝石の色を変更できます。\
 color(1)を実行した後で落とすと「赤色」、\
 color(2)を実行した後で落とすと「緑色」、\
 color(3)を実行した後で落とすと「青色」が落ちます。\
　コードを実行してみたら、色を変えて宝石を落としてみましょう！
 * Note:
色の番号は、このブックの中だけのルールです。
 ---
 */
//#-code-completion(everything, hide)
//#-code-completion(identifier, show, 🟥, 🟩, 🟦)
//#-editable-code
//ここからプログラムです。
color(1) //赤
drop(3) //３番目に落とす。
color(2) //緑
drop(4) //４番目に落とす。
color(3) //青
drop(5) //５番目に落とす。


//#-end-editable-code
//#-hidden-code
sendMessage("2,1,②-😊実行しました。")
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}
//#-end-hidden-code
