//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = false
let 🔳 = 0
let 🟥 = 1
let 🟩 = 2
let 🟦 = 3
func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func clear() {
    send("clear")
    send("color 1")
}

func drop(_ x: Int) {
    if(x > 0 && x < 11) {
        Thread.sleep(forTimeInterval: 0.5)
        send("drop "+x.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["drop()の引数に範囲外の値が指定されています。drop()の括弧内には1〜10の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}


func color(_ t: Int) {
    if(t >= 0 && t < 4) {
        send("color "+t.description)
    } else {
        PlaygroundPage.current.assessmentStatus = .fail(hints: ["color()の引数に範囲外の値が指定されています。color()の括弧内には0〜3の整数型(Int)の数値を入れてください。"], solution: nil)
    }
}

func sendMessage(_ message: String) {
    send("message "+message)
}
//#-end-hidden-code
/*: some text
 ##  📖⑤繰り返しの処理
　同じプログラムコードを指定した回数繰り返す事ができます。\
　繰り返しのことを「ループ」といいます。\
　ここでは、「for」ループを使って繰り返し実行をしてみましょう。\
　for i in 1...10 とすれば、iの値が1から10まで1ずつ変化しながら繰り返します。
 * Example:
 `for i in 1...10 {`\
 `　　drop(i)`\
 `}`
 ---
 このページのプログラムで宝石がどのように落ちるかわかりますか？
 */
//#-code-completion(everything, hide)
//#-code-completion(identifier, show, 🟥, 🟩, 🟦)
//#-hidden-code
clear()
//#-end-hidden-code
//#-editable-code
//ここからプログラムです。
color(3) //青
for i in 1 ... 10 { //1から10まで繰り返す。
    drop(5) //５番目に落とす。
}

//#-end-editable-code
//#-hidden-code
sendMessage("5,1,⑤-😊実行しました。")
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "😊実行しました。")
}
//#-end-hidden-code
