//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import BookCore
import Foundation
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

//#-end-hidden-code
/*: some text
 ##  ⚙️スクール設定
 　このページは、学校Idと通信方法等を設定するものです。\
 授業の開始前にこのページで［▶︎ コードを実行］ボタンを押して、設定値を保存してください。\
 この設定をした後で保存したBookは、設定値を維持した状態になります。\
 児童・生徒にBookを配布する場合には、先生モードを"Off"にして実行した後、このコードを削除してから配布してください。
  * Callout(⚠️注意事項):
・学校コード(schoolId)は、制作会社から発行されるIDです。\
・webModeが"Off"の場合は教室内Wi-Fiのみの接続になります。\
・teacherModeが"Off"の場合は、進捗状況が表示されません。
 */

//#-code-completion(everything, hide)
//#-editable-code
//このコードは設定用のコードです。児童・生徒に配布する前に実行してください。

//スクールIDを設定
let schoolId = "2100sample"
//webModeを設定("On"または"Off")
let webMode = "On"
//teacherモードを設定("On"または"Off")
let teacherMode = "On"
//#-end-editable-code
//#-hidden-code
// PlaygroundKeyValueStoreに番号を保存
var saved = false

if schoolId.count > 0 && webMode.count > 0 && teacherMode.count > 0 {
    PlaygroundKeyValueStore.current["schoolId"] = .string(schoolId)
    PlaygroundKeyValueStore.current["webMode"] = .string(webMode)
    PlaygroundKeyValueStore.current["teacherMode"] = .string(teacherMode)
    saved = true
}
// 保存処理のために短い遅延を追加
if saved {
    DispatchQueue.main.asyncAfter(deadline: .now() + 0.2) {
        send("update")
    }
}

//結果の通知
if saved {
    PlaygroundPage.current.assessmentStatus = .pass(message: "設定を保存しました。")
} else {
    PlaygroundPage.current.assessmentStatus = .pass(message: "設定は保存できませんでした。")
}
//#-end-hidden-code

