//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
//#-end-hidden-code
/*: some text
 ## ① こんにちは、世界！
　プログラミングで文字を出す事から始めましょう！\
print()文で、文字表示ビューに文字が表示できます。\
　このプログラムの実行結果を確認してみてください。１回確認できたら、同じプログラムを２回、３回と確認してみてください。\
 　確認ができたら、日本語で「こんにちは、世界！」と表示してみてください。
 
 * Note:
 print("text")は文字「text」を出力します。文字はダブルクォーテーション記号（"）で挟んでください。
 ---
  * Important:
　[\n]（バックスラッシュ記号と小文字のn）は、改行（次の行の先頭に移動）する特別な文字を表します。\
 日本語（全角文字）と英語（半角文字）との区別ができるようになってください。
 */
//#-code-completion(everything, hide)
//#-editable-code
//プログラムはこの次の行からです。
print("Hello World!\n") //文字を出力

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
