//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ##  ② 文字と数値
　プログラミングで計算する時には、「文字」ではなく「数値」を使います。\
　１＋２＋３の計算結果は６ですが、プログラミングでこの計算をした結果を表示してみましょう。\
　結果の確認が出来たら、色々な計算を試してみてください。
 * Note:
 print(0)は、数値0を出力します。
 ---
  * Important:
  文字と数値の違いについて確認しておきましょう。
 */
//#-code-completion(everything, hide)
//#-editable-code
print("1+2+3 = ") //文字を出力
print(1+2+3) //数値を出力
print("\n") //改行文字を出力

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
