//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ##  ③ 計算結果を色分けしてみよう！
　このページでは、文字の色が指定出来ます。そのためにcolor()という文を使います。プログラムを実行して結果を確認してみてください。\
　確認が出来たら、色を変更して計算結果の色を変えてみてください。
 * Note:
 color()で指定すると、次からの文字の色が変わります。\
 clear()を実行すると、文字表示ビューをリセットします。
 ---
  * Important:
  clear()とcolor()を使う順序をしっかり確認してください。
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //文字エリアをクリア
color(#colorLiteral(red: 0, green: 0, blue: 0, alpha: 1))//文字の色を指定
print("4+5+6 = ") //文字を出力
color(#colorLiteral(red: 0.8078431487, green: 0.02745098062, blue: 0.3333333433, alpha: 1))//文字の色を指定
print(4+5+6) //数値を出力

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
