//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ##  ④ 数値を変数に入れてみよう！
　プログラミングでは数値を変数（アルファベットや数字などで名前のついた入れ物）に入れて取り扱う事になります。\
　ここでは、数値を変数に代入して計算をしてみましょう！実行結果を確認したら、表示された内容とプログラムの内容を比較して、プログラム通り動いているか確認してみてください。
 * Note:
 　変数は数値を入れておくための記憶場所で、アルファベットや数字で名前をつけます。Swiftプレイグラウンドでは、変数の中に入っている数値をプログラム実行中や実行後に[123]ボタンで確認する事ができます。
 ---
  * Important:
 （例）let abc = 10という式は、abcという名前の変数に数値10を入れます。
 */
//#-code-completion(everything, hide)
//#-editable-code
//変数に値を入れる
let hensu1 = 5 //変数の中の値が確認できます→
let hensu2 = 10 //変数の中の値が確認できます→
let hensu3 = 15 //変数の中の値が確認できます→
print(hensu1) //変数の値を出力
print("+") //文字を出力
print(hensu2) //変数の値を出力
print("+") //文字を出力
print(hensu3) //変数の値を出力
print(" = ") //文字を出力
print(hensu1 + hensu2 + hensu3) //変数の計算結果を出力
print("\n") //改行文字を出力

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
