//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ## 📗 問題1：文字と数値の処理
　変数（hensu1）と変数（hensu2）の値の足し算、引き算、掛け算、割り算を計算して、出力するプログラムを完成させてください。
  * Note:
 掛け算はアスタリスク（*）記号を、割り算はスラッシュ（/）記号を使います。\
 完成したら、hensu1とhensu2の値を何度か変更して、実行結果を確認してください。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
//変数に値を入れる
let hensu1 = 5 //変数に値を入れる
let hensu2 = 10 //変数に値を入れる
clear() //画面を消去
//hensu1とhensu2の内容を出力
print("hensu1 = ")
print(hensu1)
print("\n")
print("hensu2 = ")
print(hensu2)
print("\n")
print("--------------\n") //区切り

//ここから計算結果を出力
//足し算
print("hensu1 + hensu2 = ")
//ここにプログラムを入力
print("\n")

//引き算
print("hensu1 - hensu2 = ")
//ここにプログラムを入力
print("\n")

//掛け算
print("hensu1 * hensu2 = ")
//ここにプログラムを入力
print("\n")

//割り算
print("hensu1 / hensu2 = ")
//ここにプログラムを入力
print("\n")

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
