//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ##   ⑤ 条件に応じて文字の出力を変えよう！
　変数の値に応じてその後の処理内容を変更する事を考えましょう。\
　プログラミングでは条件によって処理を分ける事を「条件分岐」と呼んでいます。ここでは、３つの試験の点数の合計点が60点以上なら「合格」と表示し、そうでなければ「不合格」と表示するプログラムを考えます。\
　プログラミングで条件分岐を行う文にif文があります。ここで、if文の使い方を学びましょう。\
　プログラムの動作が理解できたら、合計点の表示や、合格と不合格で色分けをするなどの工夫もしてみてください。
 
 * Note:
 　条件に応じて処理を分けるときには、if(条件の式) { ... } else { ... } という文を記述します。
 ---
  * Important:
 （ifを使った例）変数xの値が1か、そうでないかで処理を分ける。\
 if(x == 1) {\
　　　print("OK\n")\
 } else {\
　　　print("BAD\n")\
 }
 */
//#-code-completion(everything, hide)
//#-editable-code
//変数に値を入れる
let tensu1 = 35 //点数１の値
let tensu2 = 20 //点数２の値
let tensu3 = 15 //点数３の値

if(tensu1 + tensu2 + tensu3 >= 60) {
    print("合格\n")
} else {
    print("不合格\n")
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
