//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ## 📗 問題2：条件に応じた処理
　変数（hensu）の値が30以下なら、赤色で点数と「失敗」を、80以上なら青色で「大成功」、それ以外は黒色で「普通」と出力するプログラムを完成させてください。
 * Note:
　if文の括弧の中に別のif文を使う方法や、else if { ... }という記述をする方法があります。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
//変数に値を入れる
let hensu = 50 //変数に値を入れる
clear() //画面を消去
color(#colorLiteral(red: 0.0, green: 0.0, blue: 0.0, alpha: 1.0))//文字の色を黒に指定
//hensuの値を出力
print("hensu = ")
print(hensu)
print("\n")
print("------------\n")//区切り
//ここからプログラムの続きを入れてください。

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
