//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ##   ⑥ くり返し処理をしてみよう！
　同じ処理を繰り返す事で、プログラムの長さをとても短くできます。\
　くり返し処理を行う文にfor文があります。ここで、for文の使い方を学びましょう。\
 １から１００までの数字を画面に出力する事を考えてみると、プログラムは１００行分必要なことがわかりますが、くり返し処理ができればずっと少ない行数で済みます。その事をこのプログラムで確認してみてください。
 
 * Note:
 　for i in 1 ... 10 { ... }という文を記述すると、変数iの値を１から１０まで変更しながら括弧の中の処理をくり返します。
 ---
  * Important:
　下の２つのプログラムは同じ動作をします。記述のちがいを確認してみてください。
　for i in 0 ... 10 { ... }\
　for i in 0 ..< 11 { ... }
 */
//#-code-completion(everything, hide)
//#-editable-code
//変数に値を入れる
for i in 1 ... 10 { //iの値を変えながらくり返す
    print("i = ")
    print(i)
    print("\n")
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
