//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}
func print(_ int: Int) {
    send("print "+String(int))
}
func print(_ double: Double) {
    send("print "+String(double))
}
//#-end-hidden-code
/*: some text
 ## 📗 問題3：くり返し処理
 　変数iと変数jを使って次のような九九の表を作成してみましょう。\
 ![using kuku](figure1.png)
 
 * Note:
　表を作成するためには、ループを２重にして、横と縦の表示を考えます。\
　ループの中にループを入れる事で、２重、３重のループ処理ができます。ここでは、２重ループを使って九九の表を作成してみてください。\
　文字の位置合わせに工夫が必要です。if文を使うと解決できます。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
clear() //画面を消去
color(#colorLiteral(red: 0.0, green: 0.0, blue: 0.0, alpha: 1.0))//文字の色を黒に指定
//タイトルを出力
print("  ") //先頭行に空白文字
for i in 1 ... 9 { //iの値を変えながらくり返す。
    print("  ") //桁合わせ
    print(i)
}
print("\n")
print(" +---------------------------\n")//区切り

for i in 1 ... 9 { //iの値を変えながらくり返す。
    print(i)
    print("|")
    for j in 1 ... 9 { //jの値を変えながらくり返す。
        //ここにプログラムの続きを入れてください。
    }
    print("\n")
}
print("\n")

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
