//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ##  ① 線を引いてみよう
　まずは、画面に線を引いてみましょう！
  プログラムを実行して、どの位置に線を引かれるのか確認してみましょう。確認が出来たら、数値を変更して、自分が引きたい位置に線を引けるように理解を深めましょう。
 * Note:
 line(x1, y1, x2, x2)は、(x1,y1)と(x2,y2)の２点間に直線を引きます。\
 clear()で画面を消去、color()で線の色、width()で線の太さを指定できます。\
 画面をタップすると、タップした座標が表示されるので、座標の確認ができます。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//ここから線を引く
color(#colorLiteral(red: 0.9709131121635437, green: -0.12129444628953934, blue: -0.13555124402046204, alpha: 1.0)) //線の色
width(1.0) //線の太さを指定
line(0,0,100,100) //線を引く

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
