//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## 📗 問題8：ダイヤモンドパターン
　円の円周を均等な角度で分割して、分割した点とそれ以外の点を結んでできるパターンをダイヤモンドパターンと呼んでいます。\
　円の半径200、分割数10のダイヤモンドパターンを描いてみてください。\
 完成したら、分割数を変更してみましょう。
 * Note:
　分割した時の角度は360度をnで割ったものをラジアンにする。\
　分割した点とそれ以外の全ての点の間をline()で結びますので、２重ループで処理します。\
　このプログラムでは、半径r、分割した角度thは最初から倍制度実数型（Double）になっています。\
　くり返しに使っている変数i,j、分割数nは整数型（Int）になっていますので、型合わせが必要です。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
clear() //画面をクリア
color(#colorLiteral(red: 0.9568627477, green: 0.6588235497, blue: 0.5450980663, alpha: 1)) //線の色
width(1.0) //線の太さを指定
let r = 200.0 //円の半径(Double)
let n = 10 //分割数(Int)
let th = 360.0 / Double(n) * M_PI / 180.0 //分割後の角度(Double)
for i in 0 ... n-1 {
    //ここからプログラムの続きを入力
    let ix = Int( r * cos(Double(i)*th) )
    //let iy =
    for j in i+1 ... n {
        //let jx =
        //let jy =
        //line(ix,iy,jx,jy)
    }
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
