//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## ⑥ 図形を回転する
　ある座標を中心座標（0,0）を中心に回転する事を考えます。\
コンピュータの画面で回転する時には、方向は反時計回りがプラス方向の回転、時計回りがマイナス方向の回転になります。\
 回転前の座標（x,y）が角度thで回転するとき、回転後の座標（rx,ry）は、\
 rx = x * cos (th) - y * sin(th)\
 ry = x * sin (th) + y * cos(th)\
 で求める事ができます。\
 プログラムを実行してみて、一辺が200の長さの四角形が原点（0,0）を中心にどのように回転するのかを確認してみてください。\
 確認が出来たら、角度を変えて試してみてください。
 * Note:
このプログラムでは、四角形を描くために配列変数を使用しています。配列変数は複数の値を格納するためのものです。\
配列は格納される値の個数が0番目〜個数-1番目で
配列変数に格納されている数字の個数をカウントする場合には、「配列名.count」を使います。

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//四角形の各座標を格納するための配列
//出発点に戻すために５つの座標を使う
let x = [100,-100,-100, 100, 100]
let y = [100, 100,-100,-100, 100]

//回転前の四角形を描く
color(#colorLiteral(red: 0.0, green: 0.9914394021, blue: 1.0, alpha: 1.0)) //線の色
width(2.0) //線の太さを指定
for i in 1 ..< x.count {
    line(x[i-1], y[i-1], x[i], y[i])
}
//回転後の四角形を描く
color(#colorLiteral(red: 0.8078431487, green: 0.02745098062, blue: 0.3333333433, alpha: 1)) //線の色
width(2.0) //線の太さを指定
let th = 30.0 //回転角度
var brx = 0.0 //x座標保持用
var bry = 0.0 //y座標保持用
for i in 0 ..< x.count {
    //回転後の座標
    let rx = Double(x[i])*cos(th * M_PI / 180.0) - Double(y[i])*sin(th * M_PI / 180.0)
    let ry = Double(y[i])*cos(th * M_PI / 180.0) + Double(x[i])*sin(th * M_PI / 180.0)
    if( i > 0) {
        //２回目から線を引く
        line(Int(brx), Int(bry), Int(rx), Int(ry))
    }
    brx = rx
    bry = ry
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
