//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## ⑦ 図形を回転複写する
　図形の回転について確認できたら、回転角度を変えながら図形を複写してみましょう。\
　360度を5分割した各角度で図形を表示するプログラムになっています。\
　実行結果を確認したら、分割数を変更したり、四角形の形を自分なりに変更して見てください。

 * Note:
回転角度を変えながら実行するので、３重のループになっています。

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//四角形の各座標を格納するための配列
//出発点に戻すために５つの座標を使う
//x方向に＋150ずらしておく
let x = [100+150,-100+150,-100+150, 100+150, 100+150]
let y = [100, 100,-100,-100, 100]

//回転後の四角形を描く
color(#colorLiteral(red: 0.5279856324, green: 0.3070980608, blue: 0.9949815869, alpha: 1.0)) //線の色
width(2.0) //線の太さを指定
let n = 5 //分割数
for k in 0 ... n {
    let th = Double(k) * 360.0 / Double(n) //回転角度
    var brx = 0.0 //x座標保持用
    var bry = 0.0 //y座標保持用
    for i in 0 ..< x.count {
        //回転後の座標
        let rx = Double(x[i])*cos(th * M_PI / 180.0) - Double(y[i])*sin(th * M_PI / 180.0)
        let ry = Double(y[i])*cos(th * M_PI / 180.0) + Double(x[i])*sin(th * M_PI / 180.0)
        if( i > 0) {
            //２回目から線を引く
            line(Int(brx), Int(bry), Int(rx), Int(ry))
        }
        brx = rx
        bry = ry
    }
}
//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
