//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## 📗 問題9：図形の回転複写
　このプログラムは360度を分割数（n）を10で分割しています。\
 何もしないで一度プログラムを実行してみてください。\
 原点（0,0）が図形の中心になっているので、原点を中心にした回転をすると重なってよく見えません。\
 　そこで、回転の計算をする前にX方向に＋150移動させるようにして（原点から離して）プログラムを完成させてください。
 
 ![using zukei2](figure2.png)

 * Note:
 配列xは、プログラム中に値を入れ直すので、「let」ではなく「var」で初期化してあります。\
 図形の座標はが、どのように配列に入っているのかを確認しておいてください。\
 このプログラムを完成させるための追加内容は、x方向に＋150移動する部分だけです。

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//四角形の各座標を格納するための配列
//出発点に戻すために最初の座標を最後にも入れておく
var x = [ 0,-2,-2,-14,-14,-2,-2, -6,  -6,  6,  6,  2, 2,14,14,2, 2, 0]
let y = [16,14, 6,  2, -2,-2,-12,-14,-16,-16,-14,-12,-2,-2, 2,6,14,16]
//x方向に＋150ずらしておく
for i in 0 ..< x.count {
    //ここにプログラムを追加してください。
    
}
//回転後の四角形を描く
color(#colorLiteral(red: 0.5843137503, green: 0.8235294223, blue: 0.4196078479, alpha: 1)) //線の色
width(1.0) //線の太さを指定
let n = 10 //分割数
for k in 0 ..< n {
    let th = Double(k) * 360.0 / Double(n) //回転角度
    var brx = 0.0 //x座標保持用
    var bry = 0.0 //y座標保持用
    for i in 0 ..< x.count {
        //回転後の座標
        let rx = Double(x[i])*cos(th * M_PI / 180.0) - Double(y[i])*sin(th * M_PI / 180.0)
        let ry = Double(y[i])*cos(th * M_PI / 180.0) + Double(x[i])*sin(th * M_PI / 180.0)
        if( i > 0) { //２回目から線を引く
            line(Int(brx), Int(bry), Int(rx), Int(ry))
        }
        brx = rx
        bry = ry
    }
}
//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
