//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ##  ⑧ 回転体を作る
　３次元の座標も、２次元と同じ様に移動や回転の計算をする事ができます。３次元の回転変換は、原点を中心に回転するのではなく、軸（x軸、y軸、z軸)を中心に回転する計算は次の様になります。\
　変換前の座標(x,y,x)、変換後の座標(rx, ry, zy)、回転角度(th)のとき、
 
 [x軸周りの回転]\
 rx = x \
 ry = y*cos(th) + z*sin(th) \
 rz = -y*sin(th) + z*cos(th)
 
 [y軸周りの回転]\
 rx = x*cos(th) - z*sin(th) \
 ry = y \
 rz = x*sin(th) + z*cos(th)
 
 [z軸周りの回転]\
 rx = x*cos(th) + y*sin(th) \
 ry = -x*sin(th) + y*cos(th) \
 rz = z
 
　この計算式を使って、座標上の点をy軸周りに360度しながら結べば、y軸周りの回転体を作ることができます。\
　このプログラムでは、２点の座標（直線）をy軸周りに回転させて回転体を作っています。実行結果を確認してください。\
　実行結果が確認できたら、y軸以外の回転角度を変更してみてください。
 
 * Note:
 配列xの値を変更するためには、「let」ではなく「var」で初期化する必要があります。

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//各座標を格納するための配列
var x = [ 50, 50]
var y = [ 50,-50]
var z = [  0,  0]
//回転後の各座標を格納するための配列
var rx = [0.0, 0.0]
var ry = [0.0, 0.0]
var rz = [0.0, 0.0]
//回転前の各座標を保持するための配列
var brx = [0.0, 0.0]
var bry = [0.0, 0.0]
var brz = [0.0, 0.0]
width(1.0) //線の太さを指定
//y軸周りの回転体を作る。
let n = 20 //分割数
for j in 0 ... n {
    let th = Double(j) * 360.0 / Double(n) //回転角度
    //回転の計算
    for i in 0 ..< x.count {
        //y軸まわりの回転
        let tx = Double(x[i])*cos(th * M_PI / 180.0) - Double(z[i])*sin(th * M_PI / 180.0)
        let ty = Double(y[i])
        let tz = Double(x[i])*sin(th * M_PI / 180.0) + Double(z[i])*cos(th * M_PI / 180.0)
        //x軸周りに10度回転する。
        let ttx = tx
        let tty = ty*cos(10.0 * M_PI / 180.0)+tz*sin(10.0 * M_PI / 180.0)
        let ttz = -ty*sin(10.0 * M_PI / 180.0)+tz*cos(10.0 * M_PI / 180.0)
        //z軸周りに40度回転する。
        rx[i] = ttx*cos(40.0 * M_PI / 180.0)+tty*sin(40.0 * M_PI / 180.0)
        ry[i] = -ttx*sin(40.0 * M_PI / 180.0)+tty*cos(40.0 * M_PI / 180.0)
        rz[i] = ttz
    }
    color(#colorLiteral(red: 1.0, green: 0.2527073622, blue: 0.07590860873, alpha: 1.0)) //線の色
    if(j > 0){ //回転変換２回目から描画する。
        for i in 0 ..< x.count {
            line(Int(brx[i]), Int(bry[i]),Int(rx[i]),Int(ry[i]))
        }
    }
    for i in 0 ..< x.count {
        brx[i] = rx[i] //回転前の座標として保持
        bry[i] = ry[i] //回転前の座標として保持
        brz[i] = rz[i] //回転前の座標として保持
    }
    //回転後の図形を描画
    color(#colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)) //線の色
    for i in 1 ..< x.count {
        line(Int(rx[i-1]), Int(ry[i-1]), Int(rx[i]), Int(ry[i]))
    }
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
