//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ##  📗 問題10：回転体を作る
　回転体を表示するためのプログラムについて、理解ができたら、少し違った回転体を作って見ましょう！
 
 ![using zukei3](figure3.png)
 
　次のプログラムに、画像で表示されている座標を入れてみましょう。\
　思った通りの図形が完成したら、x軸周りの回転、z軸周りの回転角度を変更して、表示の違いを確認してみてください。
 
 * Note:
 このプログラムでは、配列に入れる数字の個数は全て統一しなければなりません。その理由は分かりますか？

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//各座標を格納するための配列
//ここを変更してください。
var x = [  0,  0,  0,  0,  0,  0,  0,  0,  0]
var y = [  0,  0,  0,  0,  0,  0,  0,  0,  0]
var z = [  0,  0,  0,  0,  0,  0,  0,  0,  0]
//回転後の各座標を格納するための配列
var rx = [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]
var ry = [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]
var rz = [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]
//回転前の各座標を保持するための配列
var brx = [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]
var bry = [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]
var brz = [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]
width(1.0) //線の太さを指定
//y軸周りの回転体を作る。
let n = 20 //分割数
for j in 0 ... n {
    let th = Double(j) * 360.0 / Double(n) //回転角度
    //回転の計算
    for i in 0 ..< x.count {
        //y軸まわりの回転
        let tx = Double(x[i])*cos(th * M_PI / 180.0) - Double(z[i])*sin(th * M_PI / 180.0)
        let ty = Double(y[i])
        let tz = Double(x[i])*sin(th * M_PI / 180.0) + Double(z[i])*cos(th * M_PI / 180.0)
        //x軸周りに30度回転する。
        let ttx = tx
        let tty = ty*cos(30.0 * M_PI / 180.0)+tz*sin(30.0 * M_PI / 180.0)
        let ttz = -ty*sin(30.0 * M_PI / 180.0)+tz*cos(30.0 * M_PI / 180.0)
        //z軸周りに30度回転する。
        rx[i] = ttx*cos(30.0 * M_PI / 180.0)+tty*sin(30.0 * M_PI / 180.0)
        ry[i] = -ttx*sin(30.0 * M_PI / 180.0)+tty*cos(30.0 * M_PI / 180.0)
        rz[i] = ttz
    }
    color(#colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)) //線の色
    if(j > 0){ //回転変換２回目から描画する。
        for i in 0 ..< x.count {
            line(Int(brx[i]), Int(bry[i]),Int(rx[i]),Int(ry[i]))
        }
    }
    for i in 0 ..< x.count {
        brx[i] = rx[i] //回転前の座標として保持
        bry[i] = ry[i] //回転前の座標として保持
        brz[i] = rz[i] //回転前の座標として保持
    }
    //回転後の図形を描画
    color(#colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)) //線の色
    for i in 1 ..< x.count {
        line(Int(rx[i-1]), Int(ry[i-1]), Int(rx[i]), Int(ry[i]))
    }
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
