//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## ③ くり返し線の描画
　くり返し処理で座標を計算する事で、複数の線を簡単に描画できます。\
　ここでは、横線（200ピクセル長）を10ピクセルずつずらしながら20本描画するプログラムを確認してください。
 * Note:
画面上の座標の単位をここでは「ピクセル」と呼んでいます。\
縦長の線を引くためにはどうすれば良いか考えてみましょう！
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//ここから横長の線を複数描く
color(#colorLiteral(red: 0.8078431487, green: 0.02745098062, blue: 0.3333333433, alpha: 1)) //線の色
width(1.0) //線の太さを指定
for i in 0 ..< 20 { //20本分くり返し
    line(0, i*10, 200, i*10)
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
