//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## 📗 問題7：アステロイドを描く
　２点の座標をずらしながら直線を引くと、アステロイド図形を描く事ができます。\
　右上のアステロイドはできていますので、残りのコードを追加して、アステロイドを完成させてみてください。\
 完成したら、分割数を変更してみましょう。
 * Note:
　分割数nはアステロイドの大きさを分割して、１回づつのずらすピクセル数を求めるために使います。\
　右上のアステロイドの方向と逆の方向の座標を考えれば、難しくなく描けます。
 ---
 * Important:
  ノートに自分でもアステロイドを描いてみると、すぐに理解できますよ。
 ---
 */
//#-code-completion(everything, hide)
//#-editable-code
clear() //画面をクリア
color(#colorLiteral(red: 0.9709131121635437, green: -0.12129444628953934, blue: -0.13555124402046204, alpha: 1.0)) //線の色
width(1.0) //線の太さを指定
let size = 300 //アステロイドの大きさ
let n = 5 //分割数

for i in 0...n {
    //右上
    line(0, size-i*size/n, i*size/n, 0)
    //左下（ここからプログラムの続きを入れる）

    //右下
    
    //左上
    
}
//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
