//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## ④ 三角関数を使う
　三角関数「sin()、cos()、tan()」を使うと、角度に応じた円周上の座標を求める事ができます。\
横のX座標は「半径×cos(角度)」で、縦のY座標は「半径×sin(角度)」で求められます。\
コンピュータでは、角度をラジアン（弧度法）という単位で処理しますが、ラジアンとは180度を円周率（π）で、360度を円周率×2（2π）で表したものです。\
　ここでは難しく考える必要はありません。ある角度をラジアンにしたい時には、その角度に「π/180」を掛ければ、その角度はラジアン単位になります。\
　このプログラムは、半径rの円周上のある角度（初期値は45度）の座標を求めています。実行を確認したら、角度を変更してみてください。
 * Note:
三角関数は、整数(Integer)ではなく倍制度実数(Double)で処理しますので、変数の型変換が必要になります。
Swiftでは、円周率（π）を「M_PI」と記述できます。

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.5) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//半径r、中心(0,0）の円を描く
let r = 200 //円の半径
circle(0,0,r)
//ここから三角関数の直線を引く
color(#colorLiteral(red: 0.4745098054, green: 0.8392156959, blue: 0.9764705896, alpha: 1)) //線の色
width(2.0) //線の太さを指定
let th = 45 //角度
//半径rの円周上の角度thの座標を求め、原点から直線を引く
let x = Int( Double(r) * cos(Double(th) * M_PI / 180.0) )
let y = Int( Double(r) * sin(Double(th) * M_PI / 180.0) )
line(0,0,x,y)
//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
