//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

//#-end-hidden-code
/*: some text
 ## ⑤ 三角関数のグラフ
　三角関数のsin()、cos()のグラフは波型になり、回転運動の位置を表す事ができます。\
このプログラムは-360度から+360度までのsin()、cos()の値をグラフ表示するものです。実行結果を確認してみてください。
 * Note:
グラフ化するために繰り返すfor文で使っている保存用の変数bthに注目してみてください。

 ---
 */
//#-code-completion(everything, hide)
//#-editable-code

clear() //画面をクリア
//X軸、Y軸を描画
color(#colorLiteral(red: 0.9999960065, green: 1.0, blue: 1.0, alpha: 1.0)) //線の色
width(0.2) //線の太さ
line(-1000,0,1000,0) //X軸
line(0,-1000,0,1000) //Y軸
//ここから三角関数のグラフを描く
let r = 150 //円の半径
color(#colorLiteral(red: 0.4666666687, green: 0.7647058964, blue: 0.2666666806, alpha: 1)) //線の色
width(2.0) //線の太さを指定
var bth = 0 //描き始めのY座標
for i in -360 ... 360 { //-180度から180度までくり返し（サインカーブ）
    let th = Int(Double(r) * sin( Double(i) * M_PI/180.0))
    line (i, bth, i, th)
    bth = th
}
color(#colorLiteral(red: 1.0, green: 0.2527073622, blue: 0.07590860873, alpha: 1.0)) //線の色
bth = r //描き初めのY座標
for i in -360 ... 360 { //-180度から180度までくり返し（コサインカーブ）
    let th = Int(Double(r) * cos( Double(i) * M_PI/180.0))
    line (i, bth, i, th)
    bth = th
}

//#-end-editable-code
//#-hidden-code
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
