//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//   playground ライブビューとコード間のメッセージハンドリング
//   playground BluetoothによるconnectionViewの表示

import UIKit
import PlaygroundSupport

public class TextViewController: UIViewController,PlaygroundLiveViewSafeAreaContainer  {
    private var myTextView  = UITextView()
    private var vstring = String()
    private var textColor = UIColor()
    
    public required init(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)!
    }
    
    public override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }

    override public func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = #colorLiteral(red: 0.2745098174, green: 0.4862745106, blue: 0.1411764771, alpha: 1)
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        // ビューパーツをコンテナ基準で配置
        //ロゴを背景に追加
        //let logoView = UIImageView(frame: myTextView.bounds)
        //logoView.frame.size = CGSize(width: 500, height: 500)
        //logoView.image = UIImage(named: "logo.png")
        //logoView.layer.cornerRadius = 10
        //logoView.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.4923396837)
        //view.addSubview(logoView)
        //logoView.translatesAutoresizingMaskIntoConstraints  = false
        //logoView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        //logoView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        //logoView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        //logoView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        //logoView.contentMode = UIView.ContentMode.scaleAspectFit
        
       //テキストビューを配置
        //myTextView.font = UIFont.systemFont(ofSize: 20)
        myTextView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        myTextView.isEditable = false
        view.addSubview(myTextView)
        myTextView.textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        myTextView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        myTextView.layer.cornerRadius = 10
        myTextView.translatesAutoresizingMaskIntoConstraints  = false
        myTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
         myTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        myTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true


    }
    
    override public func viewWillAppear(_ animated: Bool) {
    }
    
}

extension TextViewController: PlaygroundLiveViewMessageHandler {
    //Playgroundページからメッセージを受け取る際の処理。
    public func receive(_ message: PlaygroundValue) {
        if case let .string(text) = message {
            let arr:[String] = text.components(separatedBy: " ")
            if(arr.count > 1) {
                if(arr[0] == "print") {
                    for i in 1..<arr.count {
                        if(i > 1) {
                            myTextView.insertText(" ")
                        }
                        //myTextView.insertText(arr[i])
                        let string1 = myTextView.attributedText
                        let string2 = NSAttributedString(string:arr[i], attributes: [NSAttributedString.Key.foregroundColor: textColor, NSAttributedString.Key.font: UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)])
                        let newMutableString = string1!.mutableCopy() as! NSMutableAttributedString
                        newMutableString.append(string2)
                        myTextView.attributedText = newMutableString.copy() as? NSAttributedString
                    }
                }
                if(arr[0] == "clear") {
                    myTextView.text = ""
                }
                if(arr[0] == "color") {
                    let r = CGFloat(Double(arr[1])!)
                    let g = CGFloat(Double(arr[2])!)
                    let b = CGFloat(Double(arr[3])!)
                    let a = CGFloat(Double(arr[4])!)
                    textColor = UIColor(red: r, green: g, blue: b, alpha: a)
                }
                return
            } else {
            myTextView.insertText(text)
            }
            //
        }
    }
   //Playgroundページにメッセージを送る際のサンプル。
    //public func tapped() {
    //    let message: PlaygroundValue = .string("Hello!")
        //myTextView.insertText("[send to your code]Hello!\n")
    //    send(message)
   // }
    
}
