//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//


import PlaygroundSupport
import AudioToolbox
import Foundation
import UIKit
import CoreML
import Vision

let page = PlaygroundPage.current

page.needsIndefiniteExecution = true

func vprint(_ str: String) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .string(str)
       proxy1.send(message)
   }
}

func viewPhoto(_ image: UIImage) {
   if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
       let message: PlaygroundValue = .data(image.jpegData(compressionQuality: 1)!)
       proxy1.send(message)
       //let soundIdRing:SystemSoundID = 1111
       //AudioServicesPlaySystemSound(soundIdRing)
   }
}

//#-end-hidden-code
/*: some text
 ##  1️⃣画像の内容を特定
このページでは、画像の内容を同定する機械学習モデル（学習済み）として公開されている\
MobleNetV2Int8LUT\
を使用して、写真に含まれているモデルを特定します。
 * Note:
 　このブックでは、機械学習用APIのCoreML、画像処理用APIのVisionフレームワークを使用しています。
 ---
 */

//イメージをセットする。
let myImage = #imageLiteral(resourceName: "neko.jpg")
//ビューにイメージを表示する。
viewPhoto(myImage)

// 使用するCore MLモデルのインスタンスを生成
let model = try MLModel(contentsOf: try MLModel.compileModel(at:#fileLiteral(resourceName: "MobileNetV2Int8LUT.mlpackage")))

//Core MLモデルをVNCoreMLModelに変換
let coreMLModel = try VNCoreMLModel(for: model)

//解析リクエストを定義する。
let request = VNCoreMLRequest(model: coreMLModel, completionHandler: { (request, error) in
     // 解析結果を分類情報として保存
     guard let results = request.results as? [VNClassificationObservation] else {
         return
     }
    // 画像内の一番解析割合が大きいオブジェクトを文字列で表示する。
    if let firstResult = results.first {
        let objectArray = firstResult.identifier.components(separatedBy: ",")
        if objectArray.count == 1 {
            if let str = jpClassName[firstResult.identifier] {
                vprint(firstResult.identifier + ":" + str)
            } else {
                vprint(firstResult.identifier)
            }
        } else {
            if let str = jpClassName[objectArray.first!]{
                vprint(objectArray.first! + ":" + str)
            } else {
                vprint(objectArray.first!)
            }
        }
    }
})

// Visionへリクエストを送るためにUIImage→CIImageへ変換する
let ciImage = CIImage(image: myImage)

// 解析する画像をリクエストにセットする。
let handler = VNImageRequestHandler(ciImage: ciImage!)

// 画像解析リクエストを実行
do {
    try handler.perform([request])
}
catch {
    print(error)
}
