//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}

//#-end-hidden-code
/*: some text
 ## ①コンピュータが扱う数値(データ型)
　コンピュータの内部で扱われるのは**０**と**１**で表現できる数値の情報です。
 その数値の種類には、**整数**、**小数（浮動小数）**、**文字**、**論理値**などがあります。
 それぞれの値の特徴をしっかり捉えて、プログラミングを進めましょう。
 このような数値情報の種類のことを**データ型**と呼びます。

 * Note:
 Swiftの主なデータ型には、次のようなものがあります。\
 Int:整数型(Integer)、Float:浮動小数点型(Float)、Double:倍精度浮動小数点型(Double)、 String:文字列型(String)、Bool:論理型(Boolean)
---
 * Important:
 このBookで使用しているvprintln()、vprint()は、数値をこのBookの結果表示エリアに出力するためのもので、Swiftの文法にはありません。\
 vprintln():改行付きで結果出力、vprint():改行なしで結果出力
*/
//#-code-completion(everything, hide)
//#-editable-code
//各データ型の値を結果エリアに表示する
println("こんにちは！") //文字型
println(12)  //整数型
println(1.012) //浮動小数点型
println(true)//論理型
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
