//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//#-end-hidden-code
/*: some text
 ## ③繰り返し構造
　**ループ処理**を使うと、指定された回繰り返したり、ある条件が満たされるまで処理を繰り返すことができます。繰り返しの回数をカウントする変数の取り扱いには覚えておいて欲しい事があります。それは例えば１０回繰り返す時には０〜９までカウントするという事です。後で登場する**配列変数**が０番から始まるからで、疑問に思う人はそこで謎が解けます。
 * Important:
 Swiftのループ処理には、 **for** 、 **while** 、 **repeat-while** があります。処理の状況によって使い分ける事ができます。また、 **break**でループを抜けたり、 **continue**でループを強制継続できます。
 */
//#-code-completion(everything, hide)
//#-editable-code
//繰り返し(ループ）処理
for i in 0..<10 { //forループ
    println("i = " + String(i))
}

var j = 0
while ( j < 10) { //whileループ
    println("j = " + String(j))
    j += 1
}

var k = 0
repeat { //repeat-whileループ
    println("k = " + String(k))
    k += 1
} while (k < 10)
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
