//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//#-end-hidden-code
/*: some text
 ## ②配列変数の計算
　２次元の**配列変数**に値を格納することで、縦方向と横方向の計算が容易に記述できます。\
 ここでは、Ａさん, Ｂさん,\ Ｃさんの国語、数学、英語、情報の点数が入った２次元配列score[][]の横の合計、縦の合計を計算してみましょう。プログラムの最初は横の合計が出力できます。

 */
//#-code-completion(everything, hide)
//#-editable-code
var name = [ "Ａさん", "Ｂさん", "Ｃさん"]
var score = [[ 65, 70, 80, 90 ], [ 70, 90, 85, 75], [80, 70, 60, 80]]
var goukei = [0, 0, 0]
var kyoukagoukei = [0, 0, 0, 0]

//各個人の合計値を求める
for  i in 0..<score.count {
    for j in 0..<score[i].count {
        goukei[i] += score[i][j]
    }
}
//各教科の合計値を求める
for  i in 0..<score.count {
    for j in 0..<score[i].count {
        kyoukagoukei[j] += score[i][j]
    }
}

//画面に出力する
println("  氏名   国語 数学 英語 情報 合計")
for  i in 0..<score.count {
    print(name[i] + "  ")
    for j in 0..<score[i].count {
       print("  " + String(score[i][j]))
    }
    println("  " + String(goukei[i]))
}
print(" 合計   ")
for i in 0..<kyoukagoukei.count {
    print(" " + String(kyoukagoukei[i]))
}
print("\n")
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
