//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//#-end-hidden-code
/*: some text
 ## ③関数の定義
　今まで使っていたString()のように括弧がついたキーワードは**関数**の呼び出しです。プログラムは数多くの**関数**によって構成されていて、自分で定義する事ができます。\
 **関数** に渡する値を **引数** と言い、関数からの結果を **戻り値** と言います。 **関数**を定義する際には、 **引数** や **戻り値** の **データ型** を明確に記述する必要があります。
 * Note:
 Swiftの関数定義は、\
 **func 関数名(引数名:引数のデータ型) -> 戻り値のデータ型 { ...プログラムコード... }** \
 のように記述します。関数名の括弧の次にアンダーバー( **_** ) をつけると、その関数を呼び出す際に**引数名**の指定を省略できるようになります。
 */
//#-code-completion(everything, hide)
//#-editable-code
//関数定義
func countadd(_ number: Int) -> Int {
    var count = 0
    for i in 0..<number {
        count += (i + 1)
    }
    return count
}
//メインプログラム
var n = 10
print("1から" + String(n) + "まで足し合わせた結果は:")
println(countadd(n))

//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
