//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//Web APIを使う
class HttpGetClient {
    var url: URL? = nil
    var result: [String:Any]? = nil
    var retStr: String? = nil
    public var status: Int = 0
    init(_ str: String) {
        url = URL(string: str)!
    }
    
    func task() -> Int {
        self.status = 0
        let condition = NSCondition()
        let task = URLSession.shared.dataTask(with: url!) { data, response, error in
            condition.lock()
            if let jsonData = data {
                do {
                    let json = try JSONSerialization.jsonObject(with: data!, options: .allowFragments)
                    let jData = try JSONSerialization.data(withJSONObject: json, options: [])
                    let dic = try JSONSerialization.jsonObject(with: jData, options: []) as? [String: Any]
                    self.retStr = String(bytes: jData, encoding: .utf8)!
                    let results = dic?["results"] as! [[String: Any]]
                    self.result = results[0]
                    let stat = dic?["status"]
                    self.status = stat as! Int
                    condition.signal()
                    condition.unlock()
                } catch {
                    self.status = 0
                    print("parse error!")
                }
            }
        }
        condition.lock()
        task.resume()
        condition.wait()
        condition.unlock()
        return(self.status)
    }
    func get(key:String) -> String {
        if (self.status != 0) {
            return (self.result?[key] as! String)
        } else {
            return ("error!")
        }
    }
    
    func resultStr() -> String {
        if (self.status != 0) {
            return(retStr!)
        } else {
            return ("error!")
        }
    }
}

//#-end-hidden-code
/*: some text
 ## ④WebAPIの利用
 　　**オープンデータ**の活用という観点から、インターネットからデータを取得するサンプルを試してみましょう。インターネット上でデータや機能を提供するサイトとの通信は、多くが**HTTPプロトコル**で行われ、**Web API**と言います。このプログラムでデータの送受信ができる事を確認してみてください。また、**URL**表記の末尾にあるzipcode(郵便番号)の値を変更してみてください。
 * Note:
 ここで使用しているWeb API(Web Application Programming Interface)は、株式会社アイビスが運営する「zipcloud」を使ったものです。
 ---
 * Important:
 プログラムにあるHttpGetClientは、このページだけで使えるzipcloud用のクラス定義です。
 HttpGetClient(_str:String)で、strで指定したURLへのリクエストを準備します。\
 HttpGetClient.task()は、リクエストをHTTPでGETし、帰ってきたstatus(状態値)をIntで返します。\
 HttpGetClient.resultStr()は、リクエストの結果文字列を表示します。\
 HttpGetClient.get(key:String)は、指定されたkeyの値を取り出します。\
 指定できるkeyは、
 address1,address2,address3,kana1,kana2,kana3,prefcode,zipcodeです。\
  **インターネット接続がないとエラーになります。**
 
 */
//#-code-completion(everything, hide)
//#-editable-code
//郵便番号を送ると住所を返すAPIへの接続準備
let client = HttpGetClient("http://zipcloud.ibsnet.co.jp/api/search?zipcode=230-0062")
//通信を実行
let status = client.task()
//通信済のデータからキーを指定して値を取得
println("address1 = " + client.get(key: "address1"))
println("address2 = " + client.get(key: "address2"))
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
