//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//#-end-hidden-code
/*: some text
 ## ①探索アルゴリズム
　**アルゴリズム** とは、問題（計算など）を解くための手続き方法（ **算法** ）を指す言葉です。手続きを記述するプログラミングコードでは、**アルゴリズム** をうまく活用して様々な問題解決が図られています。\
   ここでは、配列の中からデータを探し出すための２つの**探索アルゴリズム（線形探索、二分探索）** を **関数** で記述してあります。データの値を変更しながら、その結果を確認してみてください。また、それぞれの関数内で比較回数をカウントしています。
 
 * Note:
 **線形探索(linear search)**\
  配列の先頭から順に値を比較して一致する場所を探し出すアルゴリズム。\
 **二分探索(binary search)**\
  昇順(もしくは降順)に並び替えられている配列内のデータの中央位置の値と比較し、大小関係から、半分ずつ探索範囲を狭めるアルゴリズム。
 */
//#-code-completion(everything, hide)
//#-editable-code
//線形探索関数
var lkaisuu = 0
func lsearch (_ data:[Int], _ value:Int) -> Int {
    for i in 0..<data.count {
        lkaisuu += 1 //比較回数
        if (data[i] == value) {
            return (i)
        }
    }
    return -1 //見つからなかった
}
//二分探索の関数
var bkaisuu = 0
func bsearch (_ data:[Int], _ value:Int, _ min:Int, _ max:Int) -> Int {
    bkaisuu += 1 //比較回数
    if (min > max) {
        return -1 //見つからなかった
    } else {
        let mid = min + Int((max - min) / 2)
        if (data[mid] > value) {
            return(bsearch(data, value, min, mid-1))
        } else if (data[mid] == value) {
            return(mid)
        } else {
            return(bsearch(data, value, mid+1, max))
        }
    }
}

//メインプログラム
let data = [2, 9, 15, 21, 28, 30, 37, 40, 51, 78]
let value = 21 //探す値
println("データ配列の内容:")
for i in data {
    print(String(i) + " ")
}
println("")
println("")
println("探したい値:" + String(value))
println("")
var n = lsearch(data, value)
if n > 0 {
    println("線形探索で見つかった場所:" + String(n + 1) + "番目")
} else {
    println("線形探索では見つかりませんでした")
}
println("線形探索の比較回数:" + String(lkaisuu))
println("")
n = bsearch(data, value, 0, data.count)
if n > 0 {
    println("二分探索で見つかった場所:" + String(n + 1) + "番目")
} else {
    println("二分探索では見つかりませんでした")
}
println("二分探索の比較回数:" + String(bkaisuu))
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
