//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//#-end-hidden-code
/*: some text
 ## ②並べ替え（ソート）
　数の並びを昇順（もしくは降順）に並び替える**アルゴリズム** を考えてみましょう。
  ここでは、ランダムに並んだ配列内の数値を昇順に並び替える**選択法**と**交換法** のプログラムコードを示します。それぞれのコードを比較して違いを理解しましょう。
 
 * Note:
 **選択ソート法(selection sort)**\
  配列の最初の要素の値とそれ以外の全ての要素を比較し、最も小さい要素を最初の要素と交換する。
 配列の最初が最小になったので、次の要素から同様に繰り返して並び替えを完成させるアルゴリズム。\
 **交換ソート法(バブルソート:bubble sort)**\
  配列の最初の要素とその隣の要素を比較して、順序関係が逆であれば交換、そうでなければそのままという操作を順に行って配列要素の最後まで処理すると、最後に最も大きな値（昇順の場合）が残ります。次からは配列要素の最初から最後の前の要素の範囲で繰り返す事で並び替えを完成させるアルゴリズム。
 */
//#-code-completion(everything, hide)
//#-editable-code
//選択ソート
var data = [21, 9, 78, 2, 37, 30, 40, 51, 28, 15]
println("最初の配列の値")
for value in data {
    print(String(value) + " ")
}
println("")
println("選択ソートの出力")
for i in 0..<data.count-1 {
    for j in i+1..<data.count {
        if(data[i] > data[j]) {
            let temp = data[i]
            data[i] = data[j]
            data[j] = temp
        }
    }
    for value in data {  //画面表示
        print(String(value) + " ")
    }
    println("")
}
println("")

//交換ソート
data = [21, 9, 78, 2, 37, 30, 40, 51, 28, 15]
println("最初の配列の値")
for value in data {
    print(String(value) + " ")
}
println("")
println("交換ソートの出力")
for i in 0..<data.count-1 {
    for j in 0..<data.count-(i+1) {
        if(data[j] > data[j+1]) {
            let temp = data[j]
            data[j] = data[j+1]
            data[j+1] = temp
        }
    }
    for value in data { //画面表示
        print(String(value) + " ")
    }
    print("\n")
}
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
