//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear 0")
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
//#-end-hidden-code
/*: some text
 ## ③クイックソート法
　配列要素の最初の並び方にもよりますが、一般に、**選択ソート** や **交換ソート** よりも高速に並び替えができる方法として**クイックソート**があります。\
　　**クイックソート**は、配列要素の並びの中心位置にある要素をピボット（中心軸になる値）に指定して、それ以外の配列要素について、ピボットの値より小さければピボットの左側へ、大きければ右側へ移動させます。移動が終わった段階で、ピボットの右側、左側それぞれで同じ操作を行い、それを繰り返す事により並び替えを完成させます。
 
 * Note:
 **クイックソート(quick sort)**\
  配列の要素をグループを分割しながらソート
 */
//#-code-completion(everything, hide)
//#-editable-code
//クイックソート関数
func qsort(_ data:inout[Int], _ start:Int, _ end:Int) {
    let pivot = data[ (start + end)/2]
    var i = start
    var j = end
    while true {
        while data[i] < pivot {
            i += 1
        }
        while data[j] > pivot {
            j -= 1
        }
        if ( i >= j) {
            break
        }
        var temp = data[i]
        data[i] = data[j]
        data[j] = temp
        i += 1
        j -= 1
    }
    for value in data { //画面表示
        print(String(value) + " ")
    }
    println("")
    
    if( start < i - 1 )
    {
        qsort(&data, start, i - 1 )
    }
    if( end > j + 1 )
    {
        qsort(&data, j + 1, end)
    }
}

//メインプログラム
var data = [21, 9, 78, 51, 37, 30, 40, 2, 28, 15]
println("最初の配列の値")
for value in data {
    print(String(value) + " ")
}
print("\n")
println("クイックソート配列の値")
qsort( &data, 0, data.count-1)
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
