//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func appendGraph(_ y: Int) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Float) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Double) {
    send("appendData "+y.description)
}

func appendGraph(_ x: Int, _ y: Int) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Float, _ y: Float) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Double, _ y: Double) {
    send("appendData "+x.description+" "+y.description)
}

func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
public func draw() {
    send("linePlot")
}
clear()
//#-end-hidden-code
/*: some text
 ## 複利計算のプログラミングをしてみよう
　利息の計算はその時点の預金額と利率との掛け算。
 電卓では簡単に計算することができません。プログラムなら簡単です。表示されたグラフの点をタップしたり、プログラムの右側にある変数の値の変化のトレースも確認してみてください。
 利息がどのように変化するのかにも注目しよう。
 */
//#-code-completion(everything, hide)
//#-editable-code
//複利計算のプログラム

let riritsu = 0.05 //利率
var yokin = [10000] //預金額格納配列の初期値
var risoku = 0 //最初の利息は0
for i in 0..<100 {
    risoku  = Int(Double(yokin[i])*riritsu)
    yokin.append(yokin[i]+risoku)
    appendGraph(yokin[i]+risoku)//グラフにデータを加える
}
draw() //グラフを描画

//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
