//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func appendGraph(_ y: Int) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Float) {
    send("appendData "+Double(y).description)
}


func appendGraph(_ y: Double) {
    send("appendData "+y.description)
}

func appendGraph(_ x: Int, _ y: Int) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Float, _ y: Float) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Double, _ y: Double) {
    send("appendData "+x.description+" "+y.description)
}


func appendBarGraph(_ y: Double) {
    send("appendBarData "+y.description)
}
func appendBarGraph(_ y: Int) {
    send("appendBarData "+Double(y).description)
}
func appendBarGraph(_ y: Float) {
    send("appendBarData "+Double(y).description)
}


func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
public func draw() {
    send("barPlot")
}
clear()
//#-end-hidden-code
/*: some text
 ## 一様乱数を使ったサイコロのシミュレーション
　ゲームでもよく使われている乱数を使ってプログラミングしてみよう。
 どのくらいの回数乱数を使えば、確率的に一様だと思えるでしょうか。
 */
//#-code-completion(everything, hide)
//#-editable-code
//サイコロのシミュレーションプログラム
let number = 100 //回数
var counter:[Double] = [0, 0, 0, 0, 0, 0] //各出目のカウント用配列
for i in 1 ... number {
    counter[Int.random(in: 0..<6)]+=1
}

for i in 0...5 {
    appendBarGraph(counter[i])
}
draw()
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
