//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func appendGraph(_ y: Int) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Float) {
    send("appendData "+Double(y).description)
}


func appendGraph(_ y: Double) {
    send("appendData "+y.description)
}

func appendGraph(_ x: Int, _ y: Int) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Float, _ y: Float) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Double, _ y: Double) {
    send("appendData "+x.description+" "+y.description)
}

func appendGraphA(_ x: Int, _ y: Int) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Float, _ y: Float) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Double, _ y: Double) {
    send("appendScatDataA "+x.description+" "+y.description)
}

func appendGraphB(_ x: Int, _ y: Int) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Float, _ y: Float) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Double, _ y: Double) {
    send("appendScatDataB "+x.description+" "+y.description)
}

func appendBarGraph(_ y: Double) {
    send("appendBarData "+y.description)
}
func appendBarGraph(_ y: Int) {
    send("appendBarData "+Double(y).description)
}
func appendBarGraph(_ y: Float) {
    send("appendBarData "+Double(y).description)
}


func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
public func draw() {
    send("scatterPlot")
}
clear()
//#-end-hidden-code
/*: some text
 ## モンテカルロ法で円周率を出してみよう
　原点を中心とした半径１の円の第一象限では４分の１の扇型となります。
 一様な乱数をX方向は０〜１まで、Y方向も０〜１までの範囲で発生させて、扇型の中に入った数を使えば円周率πが求まります。
 */
//#-code-completion(everything, hide)
//#-editable-code
//モンテカルロ法による円周率計算
let totalcount = 1000 //計算回数
var incount = 0 //円の内側に入った数
var  x  = 0.0 //X座標保存用
var y = 0.0 //Y座標保存用

for i in 1 ... totalcount {
    x = Double.random(in: 0..<1.0)
    y = Double.random(in: 0..<1.0)
    if x*x+y*y<1.0 {
        //indata.append(x: x, y: y)
        appendGraphA(x, y)//グラフAにデータを加える
        incount+=1
    } else {
        //outdata.append(x: x, y: y)
        appendGraphB(x, y)//グラフBにデータを加える
    }
}
draw() //グラフを描画
print("円周率 = ")
print(Double(incount) / Double(totalcount) * 0.4)

//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
