//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func appendGraph(_ y: Int) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Float) {
    send("appendData "+Double(y).description)
}


func appendGraph(_ y: Double) {
    send("appendData "+y.description)
}

func appendGraph(_ x: Int, _ y: Int) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Float, _ y: Float) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Double, _ y: Double) {
    send("appendData "+x.description+" "+y.description)
}

func appendGraphA(_ x: Int, _ y: Int) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Float, _ y: Float) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Double, _ y: Double) {
    send("appendScatDataA "+x.description+" "+y.description)
}

func appendGraphB(_ x: Int, _ y: Int) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Float, _ y: Float) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Double, _ y: Double) {
    send("appendScatDataB "+x.description+" "+y.description)
}

func appendBarGraph(_ y: Double) {
    send("appendBarData "+y.description)
}
func appendBarGraph(_ y: Int) {
    send("appendBarData "+Double(y).description)
}
func appendBarGraph(_ y: Float) {
    send("appendBarData "+Double(y).description)
}


func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
public func draw() {
    send("linePlot")
}
clear()
//#-end-hidden-code
/*: some text
 ## 放物運動を考えよう
　ここでは、物体が影響を受ける風や空気抵抗による摩擦を考えずに計算してみましょう。
 計算が上手くいったら、角度を調整してみてください。どんな角度だと一番遠くに飛ぶのか見つけてみてください。
 * Important:
  プログラムコードでは、角度をラジアン(弧度法)で記述します。１ラジアンはπ/180です。
 */
//#-code-completion(everything, hide)
//#-editable-code
//放物運動のシミュレーションプログラム
import UIKit //πの値を使うためにインポート
let dt=0.01 //微小時間
let v0=30.0 //初速度
let g=9.8 //重力加速度
var x = 0.0 //原点
var y = 0.0 //原点
var vx = [0.0] //速度の配列
var vy = [0.0] //速度ほ配列
let angle = 30.0*Double.pi/180.0 //角度をラジアンで設定
vx=[v0*cos(angle)] //X方向の初速度
vy=[v0*sin(angle)] //Y方向の初速度
for i in 0..<1000 {
    vx.append(vx[i])
    vy.append(vy[i]-g*dt)
    x = x+vx[i]*dt
    y = y+(vy[i]+vy[i+1])/2.0*dt
    if y < 0.0 {break} //Y座標が0を下回ったらループを抜ける
    appendGraph(x, y)//グラフにデータを加える
}
draw() //グラフを描画
//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
