//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func appendGraph(_ y: Int) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Float) {
    send("appendData "+Double(y).description)
}


func appendGraph(_ y: Double) {
    send("appendData "+y.description)
}

func appendGraph(_ x: Int, _ y: Int) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Float, _ y: Float) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Double, _ y: Double) {
    send("appendData "+x.description+" "+y.description)
}

func appendGraphA(_ x: Int, _ y: Int) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Float, _ y: Float) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Double, _ y: Double) {
    send("appendScatDataA "+x.description+" "+y.description)
}

func appendGraphB(_ x: Int, _ y: Int) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Float, _ y: Float) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Double, _ y: Double) {
    send("appendScatDataB "+x.description+" "+y.description)
}

func appendBarGraph(_ y: Double) {
    send("appendBarData "+y.description)
}
func appendBarGraph(_ y: Int) {
    send("appendBarData "+Double(y).description)
}
func appendBarGraph(_ y: Float) {
    send("appendBarData "+Double(y).description)
}


func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
public func draw() {
    send("linePlot")
}
clear()
//#-end-hidden-code
/*: some text
 ## 成長曲線とは？
　自然界でも、限られた環境条件の中で増加する個体の数の変化が**成長曲線（ロジスティック曲線）**に従う例があることが分かっています。
 個体が増加する割合と、減少する割合を**数式モデル**にできれば、プログラムは難しくありません。
 時間とともに個体数がどのように変化するのかを実行結果で確認してみてください。
 */
//#-code-completion(everything, hide)
//#-editable-code
//生物の個体数増加のプログラム
let zouka = 0.01  //増加率
let capacity = 1000.0 //環境収容力
var n = [10.0] //個体数の配列の初期値
var zoukasuu = 0.0 //増加数保存用
var gensyousuu = 0.0 //減少数保存用

for i in 0..<1000 {
    zoukasuu = n[i]*zouka
    gensyousuu = n[i]*n[i]/capacity*zouka
    n.append(n[i]+zoukasuu-gensyousuu) //データ配列に追加
    appendGraph(n[i+1])//グラフにデータを加える
}
draw() //グラフ描画

//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
