//#-hidden-code
//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  The Swift file containing the source code edited by the user of this playground book.
//
import Foundation
import PlaygroundSupport
PlaygroundPage.current.needsIndefiniteExecution = true

import PlaygroundSupport
import UIKit

let page = PlaygroundPage.current
page.needsIndefiniteExecution = true

func send(_ str: String) {
    if let proxy1 = page.liveView as? PlaygroundRemoteLiveViewProxy {
        let message: PlaygroundValue = .string(str)
        proxy1.send(message)
    }
}

func color(_ color: UIColor) {
    var red: CGFloat = 0
    var green: CGFloat = 0
    var blue: CGFloat = 0
    var alpha: CGFloat = 0
    color.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
    send("color "+red.description+" "+green.description+" "+blue.description+" "+alpha.description)
}

func width(_ width: CGFloat) {
    send("width "+width.description)
}

func clear() {
    send("clear")
}

func appendGraph(_ y: Int) {
    send("appendData "+Double(y).description)
}

func appendGraph(_ y: Float) {
    send("appendData "+Double(y).description)
}


func appendGraph(_ y: Double) {
    send("appendData "+y.description)
}

func appendGraph(_ x: Int, _ y: Int) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Float, _ y: Float) {
    send("appendData "+Double(x).description+" "+Double(y).description)
}

func appendGraph(_ x: Double, _ y: Double) {
    send("appendData "+x.description+" "+y.description)
}

func appendGraphA(_ x: Int, _ y: Int) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Float, _ y: Float) {
    send("appendScatDataA "+Double(x).description+" "+Double(y).description)
}

func appendGraphA(_ x: Double, _ y: Double) {
    send("appendScatDataA "+x.description+" "+y.description)
}

func appendGraphB(_ x: Int, _ y: Int) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Float, _ y: Float) {
    send("appendScatDataB "+Double(x).description+" "+Double(y).description)
}

func appendGraphB(_ x: Double, _ y: Double) {
    send("appendScatDataB "+x.description+" "+y.description)
}

func appendBarGraph(_ y: Double) {
    send("appendBarData "+y.description)
}
func appendBarGraph(_ y: Int) {
    send("appendBarData "+Double(y).description)
}
func appendBarGraph(_ y: Float) {
    send("appendBarData "+Double(y).description)
}


func line(_ x1: Int, _ y1: Int, _ x2: Int, _ y2: Int) {
    send("line "+String(x1)+" "+String(y1)+" "+String(x2)+" "+String(y2))
}

func circle(_ x: Int, _ y: Int, _ r: Int) {
    send("circle "+String(x)+" "+String(y)+" "+String(r))
}

func print(_ str: String) {
    send("print "+str)
}

public func print(_ int: Int) {
    send("print "+int.description)
}

public func print(_ double: Double) {
    send("print "+double.description)
}

public func print(_ float: Float) {
    send("print "+float.description)
}
public func print(_ bool: Bool) {
    send("print "+bool.description)
}

public func println(_ str: String) {
    send("print "+str+"\n")
}
public func println(_ int: Int) {
    send("print "+int.description+"\n")
}
public func println(_ double: Double) {
    send("print "+double.description+"\n")
}
public func println(_ float: Float) {
    send("print "+float.description+"\n")
}
public func println(_ bool: Bool) {
    send("print "+bool.description+"\n")
}
public func draw() {
    send("linePlot")
}

clear()
//#-end-hidden-code
/*: some text
 ## ランダムウォークって？
　平面や空間上をでたらめに歩き回る**ランダムウォーク**、実はAI(人工知能)の機械学習の分野でデータとして用いられるものになっています。
 プログラムの実行結果は毎回変わります。完成したら、何度か実行してみたり、計算回数を変えてみてください。**ランダムウォーク**に少しだけ手を加える事で、右に行き気味な歩き方や、ある地点で動きが遅くなるなどの指向性をつけることができたりします。そんなデータが人工知能の判断材料にうってつけになるわけです。
 */
//#-code-completion(everything, hide)
//#-editable-code
//ランダムウォーク
let totalcount = 100 //計算回数
var  x  = 0.0 //X座標の初期値
var y = 0.0 //Y座標の初期値

for i in 1 ... totalcount {
    x = x + Double.random(in: 0..<1.0)-0.5
    y = y + Double.random(in: 0..<1.0)-0.5
    appendGraph(x, y)//グラフにデータを加える
}
draw() //グラフ描画

//#-end-editable-code
//#-hidden-code
import PlaygroundSupport
if( PlaygroundPage.current.assessmentStatus == nil ){
    PlaygroundPage.current.assessmentStatus = .pass(message: "実行できました!")
}
//#-end-hidden-code
