//
//  LinePlot.swift
//  Charts
//

import UIKit

/// Draws a bar plot on the chart.
///
/// Properties that can affect the line plot:
///
///   - `color`. The color to use for symbols and lines.
///   - `lineWidth`. The width of the line. The default value is 4.0.
///   - `symbol`. The symbol to use for points along the line. The default value is .circle.
///   - `style`. The style to use to draw the line (for example, solid, dashed, and so on). The default value is .solid.
/// - localizationKey: LinePlot
public class BarPlot {
    
    var lineplotArray: [LinePlot] = []
    var lw:Double = 0.0
    var lc:Color = Color.blue
    
    public var lineWidth:Double {
        get {
            return self.lw
        }
        set(w) {
            for la in lineplotArray {
                la.lineWidth = w
            }
        }
    }
    
    public var color:Color {
        get {
            return self.lc
        }
        set(c) {
            for la in lineplotArray {
                la.color = c
            }
        }
    }
    
    public init(data: [Double]) {
        let lw = 30.0
        let lc = Color(UIColor(red: 0.0, green: 0.502, blue: 1.0, alpha: 0.5))
        var i = 0
        for n in data {
            lineplotArray.append(LinePlot(xyData: (1.0+Double(i), 0.0), (1.0+Double(i), n)))
            lineplotArray[i].symbol = nil
            lineplotArray[i].lineWidth = lw
            lineplotArray[i].color = lc
            i = i + 1
        }
    }
}
