//
//  PlaygroundSetup.swift
//  Charts
//

import UIKit
import PlaygroundSupport

public class ChartViewController: UIViewController, PlaygroundLiveViewSafeAreaContainer {
    private var myChartView = ChartView()
    private var lineColor = UIColor()
    private var myTextView = UITextView()
    private var plotData = XYData() //グラフデータ配列
    private var scatDataA = XYData() //点描画用グラフデータ配列（色分け用）
    private var scatDataB = XYData() //点描画用グラフデータ配列（色分け用）
    private var barData:[Double] = [] //棒グラフ用データ配列
    private var vstring = String() //テキストビュー用文字列
    private var textColor = UIColor() //テキストビューの文字色


    //public override func loadView() {
        //self.view = Chart.shared.chartView
    //}
    
    public override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = #colorLiteral(red: 0.5810584426, green: 0.1285524964, blue: 0.5745313764, alpha: 1)
        //ビューを配置
        //ロゴを背景に追加
        let logoView = UIImageView(frame: myChartView.bounds)
        logoView.frame.size = CGSize(width: 50, height: 50)
        logoView.image = UIImage(named: "logo2.png")
        logoView.layer.cornerRadius = 10
        logoView.backgroundColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 0)
        view.addSubview(logoView)
        logoView.clipsToBounds = true //はみ出さない様にする。
        logoView.translatesAutoresizingMaskIntoConstraints  = false
        logoView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        logoView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        logoView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        logoView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        logoView.contentMode = UIView.ContentMode.scaleAspectFit
        logoView.contentMode = UIView.ContentMode.topRight
        //チャート（グラフ）ビューを配置
        myChartView = Chart.shared.chartView //スタティックビューにする。
        myChartView.layer.cornerRadius = 10
        view.addSubview(myChartView)
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false
        myChartView.translatesAutoresizingMaskIntoConstraints  = false
        myChartView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        myChartView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
        myChartView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myChartView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        //テキストビューを配置
         myTextView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
         myTextView.isEditable = false
        myTextView.isUserInteractionEnabled = false
         view.addSubview(myTextView)
         myTextView.textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
         textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
         myTextView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0)
         myTextView.layer.cornerRadius = 10
         myTextView.translatesAutoresizingMaskIntoConstraints  = false
         myTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
          myTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -40).isActive = true
         myTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
         myTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
    }
}

//public func _setup() {
//    PlaygroundPage.current.liveView = ChartViewController()
//}

extension ChartViewController: PlaygroundLiveViewMessageHandler {
    //Playgroundページからメッセージを受け取る際の処理。
    public func receive(_ message: PlaygroundValue) {
        if case let .string(text) = message {
            let arr:[String] = text.components(separatedBy: " ")
            
            if(arr[0] == "clear") { //クリア命令
                //if let chartView = view as? ChartView {
                //    chartView.removeAllChartDrawables()
                //}
                // 全消し
                myChartView.removeAllChartDrawables()
                let new_data = XYData()
                let new_dataA = XYData()
                let new_dataB = XYData()
                plotData = new_data
                scatDataA = new_dataA
                scatDataB = new_dataB
                barData.removeAll()
                myTextView.text = ""
                return
            }

            if(arr[0] == "appendScatDataA") {//データ追加命令
                if(arr.count == 3) {
                    scatDataA.append(x: Double(arr[1])!, y:Double(arr[2])!)
                    return
                }
            }

            if(arr[0] == "appendScatDataB") {//データ追加命令
                if(arr.count == 3) {
                    scatDataB.append(x: Double(arr[1])!, y:Double(arr[2])!)
                    return
                }
            }
            
            if(arr[0] == "appendData") {//データ追加命令
                if(arr.count == 2) {
                    plotData.append(y: Double(arr[1])!)
                    return
                }
                if(arr.count == 3) {
                    plotData.append(x: Double(arr[1])!, y:Double(arr[2])!)
                    return
                }
            }
            
            if(arr[0] == "appendBarData") {//データ追加命令
                if(arr.count == 2) {
                    barData.append(Double(arr[1])!)
                    return
                }
            }
            
            if(arr[0] == "color") {
                let r = CGFloat(Double(arr[1])!)
                let g = CGFloat(Double(arr[2])!)
                let b = CGFloat(Double(arr[3])!)
                let a = CGFloat(Double(arr[4])!)
                lineColor = UIColor(red: r, green: g, blue: b, alpha: a)
                return
            }

            if(arr[0] == "print") {
                for i in 1..<arr.count {
                    if(i > 1) {
                        myTextView.insertText(" ")
                    }
                    //myTextView.insertText(arr[i])
                    let string1 = myTextView.attributedText
                    let string2 = NSAttributedString(string:arr[i], attributes: [NSAttributedString.Key.foregroundColor: textColor, NSAttributedString.Key.font: UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)])
                    let newMutableString = string1!.mutableCopy() as! NSMutableAttributedString
                    newMutableString.append(string2)
                    myTextView.attributedText = newMutableString.copy() as? NSAttributedString
                }
            }
            
            if(text == "linePlot") { //線グラフ描画
                let lineplot = LinePlot(xyData: plotData) //グラフを描画
                lineplot.label = "線グラフ"
                return
            }
            if(text == "scatterPlot") { //点グラフ描画
                let plotScatterA = ScatterPlot(xyData: scatDataA) //グラフを描画
                plotScatterA.color = #colorLiteral(red: 0.9254902005195618, green: 0.23529411852359772, blue: 0.10196078568696976, alpha: 1.0)
                let plotScatterB = ScatterPlot(xyData: scatDataB) //グラフを描画
                plotScatterB.color = #colorLiteral(red: 0.2392156869, green: 0.6745098233, blue: 0.9686274529, alpha: 1)
                return
            }
            
            if(text == "barPlot") { //棒グラフ
                _ = BarPlot(data: barData)//グラフを描画
                
                return
            }
        }
    }
}
