//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  A source file which is part of the auxiliary module named "BookCore".
//  Provides the implementation of the "always-on" live view.
//

import Foundation
import UIKit
import PlaygroundSupport

public class ChatViewController: UIViewController, PlaygroundLiveViewMessageHandler, PlaygroundLiveViewSafeAreaContainer {
    
    private var myIpTextView  = UITextView()
    private var connectIpTextView = UITextView()
    private var inputText = UITextView()
    private let chatTableView = UITableView()
    private var vstring = String()
    private var textColor = UIColor()
    private var connectButton = UIButton()
    private var sendButton = UIButton()
    //メッセージ格納配列
    private var messages : [String] = [] {
        didSet {
            chatTableView.reloadData()
            scrollToBottom()
        }
    }
    //メッセージタイプ格納配列
    private var messageTypes : [Int] = []
    
    func scrollToBottom(){
        DispatchQueue.main.async {
            let indexPath = IndexPath(row: self.messages.count-1, section: 0)
            self.chatTableView.scrollToRow(at: indexPath, at: .bottom, animated: true)
        }
    }
    
    override public func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = .systemCyan
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false
        //接続先のアドレス表示ビューを配置
        
        //自分のIPアドレス表示ビューを配置
        myIpTextView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        myIpTextView.isEditable = false
         view.addSubview(myIpTextView)
        myIpTextView.textColor = .darkText
        // textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        myIpTextView.backgroundColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 0.007892219388)
        myIpTextView.translatesAutoresizingMaskIntoConstraints  = false
        myIpTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 10).isActive = true
        myIpTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        myIpTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myIpTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        //このデバイスのipアドレスを取得してipAddressTextViewに表示
        myIpTextView.text = "このデバイスのIPアドレス：" + getIPV4Address()
        
        //接続先のIPアドレス表示ビューを配置
        connectIpTextView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        connectIpTextView.isEditable = false
        view.addSubview(connectIpTextView)
        connectIpTextView.textColor = .darkText
        // textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        connectIpTextView.backgroundColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 0.007892219388)
        connectIpTextView.translatesAutoresizingMaskIntoConstraints  = false
        connectIpTextView.topAnchor.constraint(equalTo: myIpTextView.bottomAnchor, constant: 10).isActive = true
        connectIpTextView.bottomAnchor.constraint(equalTo: myIpTextView.bottomAnchor, constant: 50).isActive = true
        connectIpTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        connectIpTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -100).isActive = true
        connectIpTextView.text = "接続相手のIPアドレス："
        
        //接続ボタンを配置
        connectButton.frame = CGRect(x:150, y:50, width:50, height:40)
        connectButton.setTitle("接続", for:UIControl.State.normal)
        connectButton.setTitleColor(UIColor.black, for: .normal)
        connectButton.titleLabel?.font =  UIFont.systemFont(ofSize: 20)
        connectButton.backgroundColor = UIColor.init(red:0.9, green: 0.9, blue: 0.9, alpha: 1)
        // タップされたときのaction
        connectButton.addTarget(self, action: #selector(self.connectButtonTapped), for: .touchUpInside)
        connectButton.layer.cornerRadius = 10
        view.addSubview(connectButton)
        connectButton.translatesAutoresizingMaskIntoConstraints  = false
        connectButton.topAnchor.constraint(equalTo: connectIpTextView.topAnchor, constant: 0).isActive = true
        connectButton.bottomAnchor.constraint(equalTo: connectIpTextView.bottomAnchor, constant: 0).isActive = true
        connectButton.leadingAnchor.constraint(equalTo: connectIpTextView.trailingAnchor, constant: 10).isActive = true
        connectButton.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //チャット用のtableビューを配置
        chatTableView.tableFooterView = UIView()
        chatTableView.separatorStyle = .none
        chatTableView.register(reciveMessageCell.self, forCellReuseIdentifier: reciveMessageCell.id)
        chatTableView.register(sendMessageCell.self, forCellReuseIdentifier: sendMessageCell.id)
        chatTableView.register(systemMessageCell.self, forCellReuseIdentifier: systemMessageCell.id)

        //chatTableView.rowHeight = UITableView.automaticDimension
        chatTableView.delegate = self
        chatTableView.dataSource = self
        chatTableView.frame = view.bounds
        view.addSubview(chatTableView)
        chatTableView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        //chatTableView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        chatTableView.layer.cornerRadius = 10
        
        chatTableView.translatesAutoresizingMaskIntoConstraints  = false
        chatTableView.topAnchor.constraint(equalTo: connectIpTextView.bottomAnchor, constant: 10).isActive = true
        chatTableView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -50).isActive = true
        chatTableView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        chatTableView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //入力用のテキストを配置
        inputText.font = UIFont.systemFont(ofSize: 20)
        inputText.textColor = .black
        inputText.tintColor = .black
        //inputText.backgroundColor = .opaqueSeparator
        inputText.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        view.addSubview(inputText)
        inputText.layer.cornerRadius = 10
        inputText.translatesAutoresizingMaskIntoConstraints  = false
        inputText.topAnchor.constraint(equalTo: chatTableView.bottomAnchor, constant: 10).isActive = true
        inputText.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: 0).isActive = true
        inputText.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        inputText.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -100).isActive = true
 
        // 送信ボタンの配置
        sendButton.frame = CGRect(x:30, y:50, width:100, height:40)
        sendButton.setTitle("送信", for:UIControl.State.normal)
        sendButton.setTitleColor(UIColor.black, for: .normal)
        sendButton.titleLabel?.font =  UIFont.systemFont(ofSize: 20)
        sendButton.backgroundColor = UIColor.init(red:0.9, green: 0.9, blue: 0.9, alpha: 1)
        // タップされたときのaction
        sendButton.addTarget(self, action: #selector(self.sendButtonTapped), for: .touchUpInside)
        view.addSubview(sendButton)

        sendButton.layer.cornerRadius = 10
        sendButton.translatesAutoresizingMaskIntoConstraints  = false
        sendButton.topAnchor.constraint(equalTo: inputText.topAnchor, constant: 0).isActive = true
        sendButton.bottomAnchor.constraint(equalTo: inputText.bottomAnchor, constant: 0).isActive = true
        sendButton.leadingAnchor.constraint(equalTo: inputText.trailingAnchor, constant: 10).isActive = true
        sendButton.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
    }
    
    @objc func sendButtonTapped(sender : Any) {
        if (inputText.text != "") {
            let text = "SEND " + inputText.text!
            let message: PlaygroundValue = .string(text)
            send(message)
            inputText.text = ""
            inputText.endEditing(true)
        }
        //chatTextView.text.append("[send Button]\n")
    }
    
    @objc func connectButtonTapped(sender : Any) {
        let message: PlaygroundValue = .string("CONNECT")
        send(message)
        //chatTextView.text.append("[send Button]\n")
    }
    /*
    public func liveViewMessageConnectionOpened() {
        // Implement this method to be notified when the live view message connection is opened.
        // The connection will be opened when the process running Contents.swift starts running and listening for messages.
    }
    */

    
    public func liveViewMessageConnectionClosed() {
        // Implement this method to be notified when the live view message connection is closed.
        // The connection will be closed when the process running Contents.swift exits and is no longer listening for messages.
        // This happens when the user's code naturally finishes running, if the user presses Stop, or if there is a crash.
    }
    
    public func receive(_ message: PlaygroundValue) {
        // Implement this method to receive messages sent from the process running Contents.swift.
        // This method is *required* by the PlaygroundLiveViewMessageHandler protocol.
        // Use this method to decode any messages sent as PlaygroundValue values and respond accordingly.
        if case let .string(text) = message {
            var str = text
            //chatTextView.insertText(text+"\n")
            if text.hasPrefix("RECIVE") {
                messageTypes.append(0)
                str.removeFirst(7)
                messages.append(str)
            } else if text.hasPrefix("SEND") {
                messageTypes.append(1)
                str.removeFirst(5)
                messages.append(str)
            } else if text.hasPrefix("IP") {
                str.removeFirst(3)
                connectIpTextView.text = "接続相手のIPアドレス：" + str
            } else {
                messageTypes.append(2)
                messages.append(str)
            }
            
        }
    }
}

//カスタムセルを使うための拡張
extension ChatViewController: UITableViewDelegate, UITableViewDataSource {
    public func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return messages.count
    }

    public func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        switch messageTypes[indexPath.row] {
        case 0:
            let cell = tableView.dequeueReusableCell(withIdentifier: reciveMessageCell.id, for: indexPath) as! reciveMessageCell
            cell.message = messages[indexPath.row]
            cell.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.0)
            cell.selectionStyle = .none
            return cell
        case 1:
            let cell = tableView.dequeueReusableCell(withIdentifier: sendMessageCell.id, for: indexPath) as! sendMessageCell
            cell.message = messages[indexPath.row]
            cell.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.0)
            cell.selectionStyle = .none
            return cell
        default:
            let cell = tableView.dequeueReusableCell(withIdentifier: systemMessageCell.id, for: indexPath) as! systemMessageCell
            cell.message = messages[indexPath.row]
            cell.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.0)
            cell.selectionStyle = .none
            return cell
        }
    }
}
