//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  A source file which is part of the auxiliary module named "BookCore".
//  Provides the implementation of the "always-on" live view.
//

import Foundation
import UIKit
import PlaygroundSupport

public class LightViewController: UIViewController, PlaygroundLiveViewMessageHandler, PlaygroundLiveViewSafeAreaContainer {
    
    private var myIpTextView  = UITextView()
    private let lightImageView = UIImageView()
    private let textView = UITextView()
    private var vstring = String()
    private var textColor = UIColor()

    
    override public func viewDidLoad() {
        super.viewDidLoad()

        //view.backgroundColor = .systemCyan
        view.backgroundColor = .black
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        //自分のIPアドレス表示ビューを配置
        myIpTextView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        myIpTextView.isEditable = false
         view.addSubview(myIpTextView)
        myIpTextView.textColor = .white
        // textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        myIpTextView.backgroundColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 0.007892219388)
        myIpTextView.translatesAutoresizingMaskIntoConstraints  = false
        myIpTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 10).isActive = true
        myIpTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        myIpTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myIpTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        //このデバイスのipアドレスを取得してipAddressTextViewに表示
        myIpTextView.text = "このデバイスのIPアドレス：" + getIPV4Address()
        
        //ライト表示用のimageビューを配置
        lightImageView.frame = view.bounds
        lightImageView.image = UIImage(named: "light_off.png")
        lightImageView.contentMode = .scaleAspectFill
        view.addSubview(lightImageView)
        
        lightImageView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        //chatTableView.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        lightImageView.layer.cornerRadius = 10
        
        lightImageView.translatesAutoresizingMaskIntoConstraints  = false
        lightImageView.topAnchor.constraint(equalTo: myIpTextView.bottomAnchor, constant: 10).isActive = true
        lightImageView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -50).isActive = true
        lightImageView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        lightImageView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //メッセージ表示用のビューを配置
        textView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        textView.isEditable = false
        view.addSubview(textView)
        //textView.textColor = .white
        textView.translatesAutoresizingMaskIntoConstraints  = false
        textView.topAnchor.constraint(equalTo: lightImageView.bottomAnchor, constant: 10).isActive = true
        textView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: 0).isActive = true
        textView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        textView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
    }
    
    /*
    public func liveViewMessageConnectionOpened() {
        // Implement this method to be notified when the live view message connection is opened.
        // The connection will be opened when the process running Contents.swift starts running and listening for messages.
    }
    */

    
    public func liveViewMessageConnectionClosed() {
        // Implement this method to be notified when the live view message connection is closed.
        // The connection will be closed when the process running Contents.swift exits and is no longer listening for messages.
        // This happens when the user's code naturally finishes running, if the user presses Stop, or if there is a crash.
        lightImageView.image = UIImage(named: "light_off.png")
    }
    
    public func receive(_ message: PlaygroundValue) {
        // Implement this method to receive messages sent from the process running Contents.swift.
        // This method is *required* by the PlaygroundLiveViewMessageHandler protocol.
        // Use this method to decode any messages sent as PlaygroundValue values and respond accordingly.
        if case let .string(text) = message {
            if text.hasPrefix("LIGHT-ON") {
                lightImageView.image = UIImage(named: "light_on.png")
            } else if text.hasPrefix("LIGHT-OFF") {
                lightImageView.image = UIImage(named: "light_off.png")
            } else {
                textView.text = textView.text + "\(text)\n"
            }
        }
    }
}

