//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  A source file which is part of the auxiliary module named "BookCore".
//  Provides the implementation of the "always-on" live view.
//

import Foundation
import UIKit
import PlaygroundSupport

public class OneButtonViewController: UIViewController, PlaygroundLiveViewMessageHandler, PlaygroundLiveViewSafeAreaContainer {
    
    private var inputText = UITextView()
    private var sendButton = UIButton()
    
    override public func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = .systemCyan
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        /*
        //入力用のテキストを配置
        inputText.font = UIFont.systemFont(ofSize: 20)
        inputText.textColor = .black
        inputText.tintColor = .black
        inputText.backgroundColor  = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5)
        view.addSubview(inputText)
        inputText.layer.cornerRadius = 10
        inputText.translatesAutoresizingMaskIntoConstraints  = false
        inputText.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -50).isActive = true
        inputText.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: 0).isActive = true
        inputText.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        inputText.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        */
        
        // 送信ボタンの配置
        sendButton.frame = CGRect(x:0, y:0, width:400, height: 100)
        sendButton.setTitle("　ボタン　", for:UIControl.State.normal)
        sendButton.setTitleColor(UIColor.black, for: .normal)
        sendButton.titleLabel?.font =  UIFont.systemFont(ofSize: 20)
        sendButton.backgroundColor = UIColor.init(red:0.9, green: 0.9, blue: 0.9, alpha: 1)
        // タップされたときのaction
        sendButton.addTarget(self, action: #selector(self.sendButtonTapped), for: .touchUpInside)
        view.addSubview(sendButton)

        sendButton.layer.cornerRadius = 10
        sendButton.translatesAutoresizingMaskIntoConstraints  = false
        sendButton.centerYAnchor.constraint(equalTo: view.centerYAnchor).isActive = true
        sendButton.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true

    }
    
    @objc func sendButtonTapped(sender : Any) {
        let message: PlaygroundValue = .string("TAPPED")
        send(message)
    }

    /*
    public func liveViewMessageConnectionOpened() {
        // Implement this method to be notified when the live view message connection is opened.
        // The connection will be opened when the process running Contents.swift starts running and listening for messages.
    }
    */

    
    public func liveViewMessageConnectionClosed() {
        // Implement this method to be notified when the live view message connection is closed.
        // The connection will be closed when the process running Contents.swift exits and is no longer listening for messages.
        // This happens when the user's code naturally finishes running, if the user presses Stop, or if there is a crash.
    }
    
    public func receive(_ message: PlaygroundValue) {
        // Implement this method to receive messages sent from the process running Contents.swift.
        // This method is *required* by the PlaygroundLiveViewMessageHandler protocol.
        // Use this method to decode any messages sent as PlaygroundValue values and respond accordingly.
        if case let .string(text) = message {
            if text.hasPrefix("RECIVE") {

            } else {

            }
            
        }
    }
}
