//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  A source file which is part of the auxiliary module named "BookCore".
//  Provides the implementation of the "always-on" live view.
//

import Foundation
import UIKit
import PlaygroundSupport
import PhotosUI

public class RecvPhotoViewController: UIViewController, PlaygroundLiveViewMessageHandler, PlaygroundLiveViewSafeAreaContainer {
    
    private var myIpTextView  = UITextView()
    private let photoImageView =  UIImageView()
    private let textView = UITextView()
    private var vstring = String()
    private var textColor = UIColor()

    
    override public func viewDidLoad() {
        super.viewDidLoad()

        //view.backgroundColor = .systemCyan
        view.backgroundColor = .black
        // disable auto layout
        view.translatesAutoresizingMaskIntoConstraints = false

        //自分のIPアドレス表示ビューを配置
        myIpTextView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        myIpTextView.isEditable = false
         view.addSubview(myIpTextView)
        myIpTextView.textColor = .white
        // textColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 1)
        myIpTextView.backgroundColor = #colorLiteral(red: 0, green: 0, blue: 0, alpha: 0.007892219388)
        myIpTextView.translatesAutoresizingMaskIntoConstraints  = false
        myIpTextView.topAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 10).isActive = true
        myIpTextView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.topAnchor, constant: 40).isActive = true
        myIpTextView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        myIpTextView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        //このデバイスのipアドレスを取得してipAddressTextViewに表示
        myIpTextView.text = "このデバイスのIPアドレス：" + getIPV4Address()
        
        //写真表示用のimageビューを配置
        photoImageView.frame = view.bounds
        photoImageView.image = UIImage(systemName: "photo")
        photoImageView.contentMode = .scaleAspectFit
        view.addSubview(photoImageView)
        photoImageView.isUserInteractionEnabled = true

        photoImageView.layer.cornerRadius = 10
        
        photoImageView.translatesAutoresizingMaskIntoConstraints  = false
        photoImageView.topAnchor.constraint(equalTo: myIpTextView.bottomAnchor, constant: 10).isActive = true
        photoImageView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: -50).isActive = true
        photoImageView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        photoImageView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
        
        //メッセージ表示用のビューを配置
        textView.font = UIFont.monospacedSystemFont(ofSize: 20, weight: .medium)
        textView.isEditable = false
        view.addSubview(textView)
        //textView.textColor = .white
        textView.translatesAutoresizingMaskIntoConstraints  = false
        textView.topAnchor.constraint(equalTo: photoImageView.bottomAnchor, constant: 10).isActive = true
        textView.bottomAnchor.constraint(equalTo: liveViewSafeAreaGuide.bottomAnchor, constant: 0).isActive = true
        textView.leadingAnchor.constraint(equalTo: liveViewSafeAreaGuide.leadingAnchor, constant: 20).isActive = true
        textView.trailingAnchor.constraint(equalTo: liveViewSafeAreaGuide.trailingAnchor, constant: -20).isActive = true
    }
    
    /*
    public func liveViewMessageConnectionOpened() {
        // Implement this method to be notified when the live view message connection is opened.
        // The connection will be opened when the process running Contents.swift starts running and listening for messages.
    }
    */

    public func liveViewMessageConnectionClosed() {
        // Implement this method to be notified when the live view message connection is closed.
        // The connection will be closed when the process running Contents.swift exits and is no longer listening for messages.
        // This happens when the user's code naturally finishes running, if the user presses Stop, or if there is a crash.
        textView.text = ""
    }
    
    public func receive(_ message: PlaygroundValue) {
        // Implement this method to receive messages sent from the process running Contents.swift.
        // This method is *required* by the PlaygroundLiveViewMessageHandler protocol.
        // Use this method to decode any messages sent as PlaygroundValue values and respond accordingly.
        if case let .data(data) = message {
            if !data.isEmpty {
                //photoImageView.image = UIImage(data: data)
                UIView.transition(with: photoImageView,
                                  duration: 0.75,
                                  options: .transitionFlipFromLeft,
                                  animations: { self.photoImageView.image = UIImage(data: data) },
                                  completion: nil)
            } else {
                textView.text = textView.text + "dataが空です。\n"
            }
        }
        if case let .string(text) = message {
            textView.text = textView.text + "\(text)\n"
        }
    }
}
