//
//  See LICENSE folder for this template’s licensing information.
//
//  Abstract:
//  A source file which is part of the auxiliary module named "BookCore".
//  Provides the implementation of the "always-on" live view.
//

import Foundation
import UIKit
import PlaygroundSupport

//
//TableViewに表示するセル
//
//受け取ったメッセージを表示するカスタムセル
class reciveMessageCell: UITableViewCell {

    static let id = "reciveMessageCell"

    public var message: String? {
        didSet {
            messageLabel.text = message
        }
    }

    private let profileImageView: UIImageView = {
        let imageView = UIImageView()
        imageView.image = UIImage(systemName: "person.fill")
        imageView.layer.masksToBounds = true
        imageView.layer.cornerRadius = 25
        imageView.layer.borderWidth = 2
        imageView.layer.borderColor = UIColor.opaqueSeparator.cgColor
        imageView.layer.backgroundColor = UIColor.white.cgColor
        return imageView
    }()
    private let backView: UIView = {
        let view = UIView()
        view.backgroundColor = .systemBlue
        view.layer.cornerRadius = 10
        view.layer.masksToBounds = true
        return view
    }()
    private let messageLabel: UILabel = {
        let label = UILabel()
        label.font = .systemFont(ofSize: 16)
        label.textColor = .white
        // labelの行数を指定
        label.numberOfLines = 0
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        addSubview(profileImageView)
        addSubview(backView)
        backView.addSubview(messageLabel)

        setupAutoLayout()
    }

    private func setupAutoLayout() {
        profileImageView.translatesAutoresizingMaskIntoConstraints = false
        backView.translatesAutoresizingMaskIntoConstraints = false
        messageLabel.translatesAutoresizingMaskIntoConstraints = false

        let constraints = [
            profileImageView.topAnchor.constraint(equalTo: topAnchor, constant: 10),
            profileImageView.leadingAnchor.constraint(equalTo: leadingAnchor, constant: 10),
//            profileImageView.bottomAnchor.constraint(equalTo: bottomAnchor, constant: -10),
            profileImageView.widthAnchor.constraint(equalToConstant: 50),
            profileImageView.heightAnchor.constraint(equalToConstant: 50),

            backView.topAnchor.constraint(equalTo: profileImageView.topAnchor),
            backView.leadingAnchor.constraint(equalTo: profileImageView.trailingAnchor, constant: 5),
            backView.bottomAnchor.constraint(equalTo: bottomAnchor, constant: -10),
            backView.widthAnchor.constraint(lessThanOrEqualToConstant: 250),

            messageLabel.topAnchor.constraint(equalTo: backView.topAnchor, constant: 8),
            messageLabel.leadingAnchor.constraint(equalTo: backView.leadingAnchor, constant: 8),
            messageLabel.bottomAnchor.constraint(equalTo: backView.bottomAnchor, constant: -8),
            messageLabel.trailingAnchor.constraint(equalTo: backView.trailingAnchor, constant: -8),
        ]

        NSLayoutConstraint.activate(constraints)
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}

//送ったたメッセージを表示するカスタムセル
class sendMessageCell: UITableViewCell {

    static let id = "sendMessageCell"

    public var message: String? {
        didSet {
            messageLabel.text = message
        }
    }

    private let backView: UIView = {
        let view = UIView()
        view.backgroundColor = .systemCyan
        view.layer.cornerRadius = 10
        view.layer.masksToBounds = true
        return view
    }()
    private let messageLabel: UILabel = {
        let label = UILabel()
        label.font = .systemFont(ofSize: 16)
        label.textColor = .white
        // labelの行数を指定
        label.numberOfLines = 0
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)

        //addSubview(profileImageView)
        addSubview(backView)
        backView.addSubview(messageLabel)
        setupAutoLayout()
    }

    private func setupAutoLayout() {
        backView.translatesAutoresizingMaskIntoConstraints = false
        messageLabel.translatesAutoresizingMaskIntoConstraints = false

        let constraints = [
            backView.topAnchor.constraint(equalTo: topAnchor, constant: 10),
            backView.trailingAnchor.constraint(equalTo: trailingAnchor, constant: -10),
            backView.bottomAnchor.constraint(equalTo: bottomAnchor, constant: -10),
            backView.widthAnchor.constraint(lessThanOrEqualToConstant: 250),

            messageLabel.topAnchor.constraint(equalTo: backView.topAnchor, constant: 8),
            messageLabel.leadingAnchor.constraint(equalTo: backView.leadingAnchor, constant: 8),
            messageLabel.bottomAnchor.constraint(equalTo: backView.bottomAnchor, constant: -8),
            messageLabel.trailingAnchor.constraint(equalTo: backView.trailingAnchor, constant: -8),
        ]

        NSLayoutConstraint.activate(constraints)
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}


//システムのメッセージを表示するセル
class systemMessageCell: UITableViewCell {

    static let id = "systemMessageCell"

    public var message: String? {
        didSet {
            messageLabel.text = message
        }
    }

    private let backView: UIView = {
        let view = UIView()
        view.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 0.5084768282)
        view.layer.cornerRadius = 0
        view.layer.masksToBounds = true
        return view
    }()
    private let messageLabel: UILabel = {
        let label = UILabel()
        label.font = .systemFont(ofSize: 12)
        label.textColor = .black
        label.textAlignment = NSTextAlignment.center
        // labelの行数を指定
        label.numberOfLines = 0
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)

        //addSubview(profileImageView)
        addSubview(backView)
        backView.addSubview(messageLabel)

        setupAutoLayout()
    }

    private func setupAutoLayout() {
        backView.translatesAutoresizingMaskIntoConstraints = false
        messageLabel.translatesAutoresizingMaskIntoConstraints = false

        let constraints = [
            backView.topAnchor.constraint(equalTo: topAnchor, constant: 5),
            backView.trailingAnchor.constraint(equalTo: trailingAnchor, constant: 0),
            backView.bottomAnchor.constraint(equalTo: bottomAnchor, constant: -5),
            backView.leadingAnchor.constraint(equalTo: leadingAnchor, constant: 0),
            backView.trailingAnchor.constraint(equalTo: trailingAnchor, constant: 0),
            messageLabel.topAnchor.constraint(equalTo: backView.topAnchor, constant: 8),
            messageLabel.leadingAnchor.constraint(equalTo: backView.leadingAnchor, constant: 10),
            messageLabel.bottomAnchor.constraint(equalTo: backView.bottomAnchor, constant: -8),
            messageLabel.trailingAnchor.constraint(equalTo: backView.trailingAnchor, constant: -10),
        ]

        NSLayoutConstraint.activate(constraints)
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}
